/*
 * Decompiled with CFR 0.152.
 */
package com.krishna.fileloader;

import android.content.Context;
import android.os.AsyncTask;
import com.krishna.fileloader.listener.MultiFileDownloadListener;
import com.krishna.fileloader.network.FileDownloader;
import com.krishna.fileloader.utility.AndroidFileManager;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class MultiFileDownloadTask
extends AsyncTask<String, Integer, Void> {
    private MultiFileDownloadListener listener;
    private String dirName;
    private int dirType;
    private Context context;
    private int totalTasks = 0;
    private int progress = 0;
    private List<File> downloadedFiles;
    private boolean forceLoadFromNetwork;

    public MultiFileDownloadTask(Context context, String dirName, int dirType, MultiFileDownloadListener listener, boolean forceLoadFromNetwork) {
        this.dirName = dirName;
        this.dirType = dirType;
        this.context = context.getApplicationContext();
        this.listener = listener;
        this.forceLoadFromNetwork = forceLoadFromNetwork;
        this.downloadedFiles = new ArrayList<File>();
    }

    protected Void doInBackground(String ... urls) {
        this.totalTasks = urls.length;
        for (String url : urls) {
            try {
                File downloadedFile = null;
                if (!this.forceLoadFromNetwork) {
                    downloadedFile = AndroidFileManager.searchAndGetLocalFile(this.context, url, this.dirName, this.dirType);
                }
                if (downloadedFile == null || !downloadedFile.exists()) {
                    FileDownloader downloader = new FileDownloader(this.context, url, this.dirName, this.dirType);
                    downloadedFile = downloader.download();
                }
                this.downloadedFiles.add(downloadedFile);
                this.publishProgress(new Integer[]{++this.progress});
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    protected void onProgressUpdate(Integer ... values) {
        super.onProgressUpdate((Object[])values);
        if (this.listener != null) {
            try {
                this.listener.onProgress(this.downloadedFiles.get(values[0] - 1), values[0], this.totalTasks);
            }
            catch (Exception e) {
                try {
                    this.listener.onError(e, values[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

