/*
 * Decompiled with CFR 0.152.
 */
package ki.pagetransformer.sharedelement;

import android.app.Activity;
import android.view.View;
import androidx.fragment.app.Fragment;
import androidx.viewpager.widget.ViewPager;
import java.util.List;
import ki.pagetransformer.sharedelement.AbstractSePageTransformer;

public class DefaultSePageTransformer
extends AbstractSePageTransformer {
    public DefaultSePageTransformer(Activity activity, List<Fragment> fragments, ViewPager viewPager) {
        super(activity, fragments, viewPager);
    }

    @Override
    protected void modifyPositions(View fromView, View toView, View fromPage, View toPage, View currentPage, float position, boolean slideToTheRight) {
        float fromX = fromView.getX() - fromView.getTranslationX();
        float fromY = fromView.getY() - fromView.getTranslationY();
        float toX = toView.getX() - toView.getTranslationX();
        float toY = toView.getY() - toView.getTranslationY();
        float deltaX = toX - fromX;
        float deltaY = toY - fromY;
        float fromWidth = fromView.getWidth();
        float fromHeight = fromView.getHeight();
        float toWidth = toView.getWidth();
        float toHeight = toView.getHeight();
        float deltaWidth = toWidth - fromWidth;
        float deltaHeight = toHeight - fromHeight;
        int fromId = fromView.getId();
        int toId = toView.getId();
        if (!(position <= -1.0f) && position < 1.0f) {
            float scaleY;
            float scaleX;
            float pageWidth = this.getPageWidth();
            float sign = slideToTheRight ? 1.0f : -1.0f;
            float translationY = (deltaY + deltaHeight / 2.0f) * sign * -position;
            float translationX = (deltaX + sign * pageWidth + deltaWidth / 2.0f) * sign * -position;
            if (currentPage.findViewById(fromId) != null) {
                fromView.setTranslationX(translationX);
                fromView.setTranslationY(translationY);
                scaleX = fromWidth == 0.0f ? 1.0f : (fromWidth + deltaWidth * sign * -position) / fromWidth;
                scaleY = fromHeight == 0.0f ? 1.0f : (fromHeight + deltaHeight * sign * -position) / fromHeight;
                fromView.setScaleX(scaleX);
                fromView.setScaleY(scaleY);
            }
            if (currentPage.findViewById(toId) != null) {
                toView.setTranslationX(translationX);
                toView.setTranslationY(translationY);
                scaleX = toWidth == 0.0f ? 1.0f : (toWidth + deltaWidth * sign * -position) / toWidth;
                scaleY = toHeight == 0.0f ? 1.0f : (toHeight + deltaHeight * sign * -position) / toHeight;
                toView.setScaleX(scaleX);
                toView.setScaleY(scaleY);
            }
        }
    }
}

