/*
 * Decompiled with CFR 0.152.
 */
package ki.pagetransformer.sharedelement;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.util.Pair;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import androidx.fragment.app.Fragment;
import androidx.viewpager.widget.ViewPager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ki.pagetransformer.sharedelement.AbstractSePageTransformer;

public class AuxiliarySePageTransformer
extends AbstractSePageTransformer {
    private Map<Pair<Integer, Integer>, ImageView> intermediateViews = new HashMap<Pair<Integer, Integer>, ImageView>();
    private final Object relativeLayout;

    public AuxiliarySePageTransformer(Activity activity, List<Fragment> fragments, ViewPager viewPager, Object relativeLayout) {
        super(activity, fragments, viewPager);
        this.relativeLayout = relativeLayout;
    }

    @Override
    protected void modifyPositions(View fromView, View toView, View fromPage, View toPage, View currentPage, float position, boolean slideToTheRight) {
        Integer fromViewId = fromView.getId();
        Integer toViewId = toView.getId();
        Pair idPair = Pair.create((Object)fromView.getId(), (Object)toView.getId());
        if (fromView instanceof ImageView && toView instanceof ImageView && !this.intermediateViews.containsKey(idPair)) {
            ImageView imageView = new ImageView((Context)this.activity);
            imageView.setImageDrawable(((ImageView)fromView).getDrawable());
            imageView.setMaxWidth(fromView.getWidth());
            imageView.setMinimumWidth(fromView.getWidth());
            imageView.setMaxHeight(fromView.getHeight());
            imageView.setMinimumHeight(fromView.getHeight());
            imageView.setScaleType(((ImageView)fromView).getScaleType());
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(fromView.getWidth(), fromView.getHeight());
            int[] fromViewPosition = new int[2];
            fromView.getLocationInWindow(fromViewPosition);
            int[] layoutPosition = this.getLayoutPosition();
            params.leftMargin = fromViewPosition[0] - layoutPosition[0];
            params.topMargin = fromViewPosition[1] - layoutPosition[1];
            this.intermediateViews.put((Pair<Integer, Integer>)idPair, imageView);
            ((RelativeLayout)this.relativeLayout).addView((View)imageView, (ViewGroup.LayoutParams)params);
        }
        float fromX = this.idToAbsX.get(fromViewId) != null ? ((Float)this.idToAbsX.get(fromViewId)).floatValue() : fromView.getX() - fromView.getTranslationX();
        float fromY = this.idToAbsY.get(fromViewId) != null ? ((Float)this.idToAbsY.get(fromViewId)).floatValue() : fromView.getY() - fromView.getTranslationY();
        float toX = this.idToAbsX.get(toViewId) != null ? ((Float)this.idToAbsX.get(toViewId)).floatValue() : toView.getX() - toView.getTranslationX();
        float toY = this.idToAbsY.get(toViewId) != null ? ((Float)this.idToAbsY.get(toViewId)).floatValue() : toView.getY() - toView.getTranslationY();
        float deltaX = toX - fromX;
        float deltaY = toY - fromY;
        float fromWidth = fromView.getWidth();
        float fromHeight = fromView.getHeight();
        float toWidth = toView.getWidth();
        float toHeight = toView.getHeight();
        float deltaWidth = toWidth - fromWidth;
        float deltaHeight = toHeight - fromHeight;
        int fromId = fromView.getId();
        int toId = toView.getId();
        if (position <= -1.0f) {
            ImageView intermediateView = this.intermediateViews.get(idPair);
            if (intermediateView != null && currentPage.findViewById(fromId) != null) {
                intermediateView.setVisibility(4);
            }
        } else if (position < 1.0f) {
            float sign = slideToTheRight ? 1.0f : -1.0f;
            ImageView intermediateView = this.intermediateViews.get(idPair);
            if (intermediateView != null && currentPage.findViewById(fromId) != null) {
                float translationXx = (deltaX + deltaWidth / 2.0f) * sign * -position;
                float translationYy = (deltaY + deltaHeight / 2.0f) * sign * -position;
                Float fromViewX = (Float)this.idToAbsX.get(fromId);
                Float fromViewY = (Float)this.idToAbsY.get(fromId);
                if (intermediateView.getLayoutParams() instanceof ViewGroup.MarginLayoutParams && fromViewX != null) {
                    ViewGroup.MarginLayoutParams p = (ViewGroup.MarginLayoutParams)intermediateView.getLayoutParams();
                    if (Build.VERSION.SDK_INT >= 17) {
                        int[] layoutPosition = this.getLayoutPosition();
                        int marginX = (int)(translationXx + fromViewX.floatValue() - (float)layoutPosition[0]);
                        int marginY = (int)(translationYy + fromViewY.floatValue() - (float)layoutPosition[1]);
                        p.setMarginStart(marginX);
                        p.topMargin = marginY;
                    }
                    intermediateView.requestLayout();
                }
                float scaleX = fromWidth == 0.0f ? 1.0f : (fromWidth + deltaWidth * sign * -position) / fromWidth;
                float scaleY = fromHeight == 0.0f ? 1.0f : (fromHeight + deltaHeight * sign * -position) / fromHeight;
                intermediateView.setScaleX(scaleX);
                intermediateView.setScaleY(scaleY);
                intermediateView.setVisibility(0);
                ImageView imageView = this.intermediateViews.get(Pair.create((Object)idPair.second, (Object)idPair.first));
                if (imageView != null) {
                    imageView.setVisibility(4);
                }
            }
            if (currentPage.findViewById(fromId) != null) {
                if (position == 0.0f) {
                    fromView.setVisibility(0);
                } else {
                    fromView.setVisibility(4);
                }
            }
            if (currentPage.findViewById(toId) != null) {
                if (position == 0.0f) {
                    toView.setVisibility(0);
                } else {
                    toView.setVisibility(4);
                }
            }
        } else {
            ImageView intermediateView = this.intermediateViews.get(idPair);
            if (intermediateView != null && currentPage.findViewById(fromId) != null) {
                intermediateView.setVisibility(4);
            }
        }
    }

    private int[] getLayoutPosition() {
        int[] layoutPosition = new int[2];
        ((View)this.relativeLayout).getLocationInWindow(layoutPosition);
        return layoutPosition;
    }

    @Override
    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        super.onPageScrolled(position, positionOffset, positionOffsetPixels);
        float pageWidth = this.getPageWidth();
        for (Pair idPair : this.sharedElementIds) {
            for (int i = 0; i < this.pages.size(); ++i) {
                View secondView;
                View page = (View)this.pages.get(i);
                if (page == null) {
                    return;
                }
                View firstView = page.findViewById(((Integer)idPair.first).intValue());
                if (firstView != null) {
                    float x = (float)this.getX(firstView) - ((float)i - ((float)position + positionOffset)) * pageWidth;
                    this.idToAbsX.put(firstView.getId(), Float.valueOf(x));
                    this.idToAbsY.put(firstView.getId(), Float.valueOf(this.getY(firstView)));
                }
                if ((secondView = page.findViewById(((Integer)idPair.second).intValue())) == null) continue;
                float x = (float)this.getX(secondView) - ((float)i - ((float)position + positionOffset)) * pageWidth;
                this.idToAbsX.put(secondView.getId(), Float.valueOf(x));
                this.idToAbsY.put(secondView.getId(), Float.valueOf(this.getY(secondView)));
            }
        }
    }

    public int getX(View view) {
        int[] position = new int[2];
        view.getLocationOnScreen(position);
        return position[0];
    }

    public int getY(View view) {
        int[] position = new int[2];
        view.getLocationOnScreen(position);
        return position[1];
    }
}

