/*
 * Decompiled with CFR 0.152.
 */
package net.kinguin.leadership.consul.factory;

import com.ecwid.consul.v1.kv.KeyValueClient;
import com.ecwid.consul.v1.kv.KeyValueConsulClient;
import com.ecwid.consul.v1.session.SessionConsulClient;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import net.kinguin.leadership.consul.config.ClusterConfiguration;
import net.kinguin.leadership.consul.election.ConsulMember;
import net.kinguin.leadership.consul.operation.CreateSession;
import net.kinguin.leadership.consul.operation.UpkeepSession;
import net.kinguin.leadership.core.DummyMember;
import net.kinguin.leadership.core.Member;
import net.kinguin.leadership.core.factory.AbstractClusterFactory;
import net.kinguin.leadership.core.factory.ClusterFactoryException;

public class SimpleConsulClusterFactory
extends AbstractClusterFactory {
    private SessionConsulClient sessionConsulClient;
    private KeyValueConsulClient keyValueConsulClient;
    private ScheduledExecutorService executor;
    private ClusterConfiguration config;
    private String sessionId;
    private boolean debug = false;
    private static final Logger log = Logger.getLogger(SimpleConsulClusterFactory.class.getName());

    public SimpleConsulClusterFactory() {
    }

    public SimpleConsulClusterFactory(SessionConsulClient sessionConsulClient, KeyValueConsulClient keyValueConsulClient) {
        this.sessionConsulClient = sessionConsulClient;
        this.keyValueConsulClient = keyValueConsulClient;
    }

    public SimpleConsulClusterFactory mode(String mode) {
        this.mode = mode;
        return this;
    }

    public SimpleConsulClusterFactory configure(ClusterConfiguration config) {
        this.config = config;
        return this;
    }

    public SimpleConsulClusterFactory session(SessionConsulClient sessionConsulClient) {
        this.sessionConsulClient = sessionConsulClient;
        return this;
    }

    public SimpleConsulClusterFactory session(String sessionId, int sessionTtlSeconds) {
        this.sessionId = sessionId;
        this.config.getSession().setTtl(sessionTtlSeconds);
        return this;
    }

    public SimpleConsulClusterFactory debug(boolean debug) {
        this.debug = debug;
        return this;
    }

    @Override
    public Member build() {
        this.verbose(String.format("%s mode active", this.mode));
        if ("single" == this.mode) {
            return new DummyMember();
        }
        if (null == this.config) {
            this.verbose(String.format("Configuration not specified - default used", new Object[0]));
            this.config = new ClusterConfiguration();
        }
        if (null == this.sessionConsulClient) {
            this.verbose(String.format("SessionConsulClient not specified - default used host %s and port %s", this.config.getConsul().getHost(), this.config.getConsul().getPort()));
            this.sessionConsulClient = new SessionConsulClient(this.config.getConsul().getHost(), this.config.getConsul().getPort());
        }
        String sessionId = this.createAndGetSessionId();
        this.verbose(String.format("Session created %s", sessionId));
        this.executor = new ScheduledThreadPoolExecutor(2);
        this.executor.scheduleAtFixedRate(new UpkeepSession(sessionId, this.sessionConsulClient), 0L, this.config.getSession().getRefresh(), TimeUnit.SECONDS);
        this.verbose(String.format("Session refresh scheduled on %s seconds frequency ", this.config.getSession().getRefresh()));
        if (null == this.keyValueConsulClient) {
            this.verbose(String.format("KeyValueConsulClient not specified - default used host %s and port %s", this.config.getConsul().getHost(), this.config.getConsul().getPort()));
            this.keyValueConsulClient = new KeyValueConsulClient(this.config.getConsul().getHost(), this.config.getConsul().getPort());
        }
        ConsulMember gambler = new ConsulMember((KeyValueClient)this.keyValueConsulClient, sessionId, this.config);
        this.executor.scheduleAtFixedRate(gambler, this.config.getElection().getFrequency(), this.config.getElection().getFrequency(), TimeUnit.SECONDS);
        this.verbose(String.format("Vote frequency setup on %s seconds frequency ", this.config.getElection().getFrequency()));
        return gambler;
    }

    private String createAndGetSessionId() {
        if (null != this.sessionId) {
            return this.sessionId;
        }
        ExecutorService executor = Executors.newFixedThreadPool(1);
        Future<String> sessionId = executor.submit(new CreateSession(this.config.getSession().getTtl(), this.sessionConsulClient));
        executor.shutdown();
        try {
            return sessionId.get();
        }
        catch (Exception e) {
            throw new ClusterFactoryException("Could not create cluster/consul session");
        }
    }

    private void verbose(String message) {
        if (this.debug) {
            log.info(message);
        }
    }
}

