/*
 * Decompiled with CFR 0.152.
 */
package me.next.codex.roundedbg;

import android.os.Build;
import android.text.Layout;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0012\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0004\u001a\u0012\u0010\u0007\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0004\u001a\u0012\u0010\b\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0004\u001a\u0012\u0010\t\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0004\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"DEFAULT_LINESPACING_EXTRA", "", "DEFAULT_LINESPACING_MULTIPLIER", "getLineBottomWithoutPadding", "", "Landroid/text/Layout;", "line", "getLineBottomWithoutSpacing", "getLineHeight", "getLineTopWithoutPadding", "code_extension_release"})
public final class LayoutExtensionsKt {
    private static final float DEFAULT_LINESPACING_EXTRA = 0.0f;
    private static final float DEFAULT_LINESPACING_MULTIPLIER = 1.0f;

    public static final int getLineBottomWithoutSpacing(@NotNull Layout $receiver, int line) {
        int lineBottomWithoutSpacing;
        boolean hasLineSpacing;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        int lineBottom = $receiver.getLineBottom(line);
        boolean lastLineSpacingNotAdded = Build.VERSION.SDK_INT >= 19;
        boolean isLastLine = line == $receiver.getLineCount() - 1;
        float lineSpacingExtra = $receiver.getSpacingAdd();
        float lineSpacingMultiplier = $receiver.getSpacingMultiplier();
        boolean bl = hasLineSpacing = lineSpacingExtra != 0.0f || lineSpacingMultiplier != 1.0f;
        if (!hasLineSpacing || isLastLine && lastLineSpacingNotAdded) {
            lineBottomWithoutSpacing = lineBottom;
        } else {
            float extra;
            if (Float.compare(lineSpacingMultiplier, 1.0f) != 0) {
                int lineHeight = LayoutExtensionsKt.getLineHeight($receiver, line);
                extra = (float)lineHeight - ((float)lineHeight - lineSpacingExtra) / lineSpacingMultiplier;
            } else {
                extra = lineSpacingExtra;
            }
            lineBottomWithoutSpacing = (int)((float)lineBottom - extra);
        }
        return lineBottomWithoutSpacing;
    }

    public static final int getLineHeight(@NotNull Layout $receiver, int line) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getLineTop(line + 1) - $receiver.getLineTop(line);
    }

    public static final int getLineTopWithoutPadding(@NotNull Layout $receiver, int line) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        int lineTop = $receiver.getLineTop(line);
        if (line == 0) {
            lineTop -= $receiver.getTopPadding();
        }
        return lineTop;
    }

    public static final int getLineBottomWithoutPadding(@NotNull Layout $receiver, int line) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        int lineBottom = LayoutExtensionsKt.getLineBottomWithoutSpacing($receiver, line);
        if (line == $receiver.getLineCount() - 1) {
            lineBottom -= $receiver.getBottomPadding();
        }
        return lineBottom;
    }
}

