/*
 * Decompiled with CFR 0.152.
 */
package com.kenmeidearu.materialdatetimepicker.date;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.kenmeidearu.materialdatetimepicker.R;
import com.kenmeidearu.materialdatetimepicker.date.DatePickerController;
import com.kenmeidearu.materialdatetimepicker.date.DatePickerDialog;
import com.kenmeidearu.materialdatetimepicker.date.TextViewWithCircularIndicator;
import java.util.ArrayList;
import java.util.List;

public class TimePickerView
extends ListView
implements AdapterView.OnItemClickListener,
DatePickerDialog.OnDateChangedListener {
    private static final String TAG = "TimePickerView";
    private final DatePickerController mController;
    private TimeAdapter mAdapter;
    private int mViewSize;
    private int mChildSize;
    private String typeControl;
    boolean AMPM;
    private TextViewWithCircularIndicator mSelectedView;

    public TimePickerView(Context context, DatePickerController controller, String tc, boolean AmPM) {
        super(context);
        this.typeControl = tc;
        this.AMPM = AmPM;
        this.mController = controller;
        this.mController.registerOnDateChangedListener(this);
        ViewGroup.LayoutParams frame = new ViewGroup.LayoutParams(-1, -2);
        this.setLayoutParams(frame);
        Resources res = context.getResources();
        this.mViewSize = res.getDimensionPixelOffset(R.dimen.mdtp_date_picker_view_animator_height);
        this.mChildSize = res.getDimensionPixelOffset(R.dimen.mdtp_year_label_height);
        this.setVerticalFadingEdgeEnabled(true);
        this.setFadingEdgeLength(this.mChildSize / 3);
        this.init(context);
        this.setOnItemClickListener(this);
        this.setSelector((Drawable)new StateListDrawable());
        this.setDividerHeight(0);
        this.onDateChanged();
    }

    private void init(Context context) {
        ArrayList<String> datatime;
        block32: {
            block31: {
                datatime = new ArrayList<String>();
                if (this.AMPM) break block31;
                switch (this.typeControl.toUpperCase()) {
                    case "HOUR": {
                        for (int a = 1; a <= 12; ++a) {
                            datatime.add(String.format("%d", a));
                        }
                        break block32;
                    }
                    case "MINUTE": {
                        for (int a = 0; a <= 59; ++a) {
                            if (a < 10) {
                                datatime.add("0" + String.format("%d", a));
                                continue;
                            }
                            datatime.add(String.format("%d", a));
                        }
                        break block32;
                    }
                    case "SECOND": {
                        for (int a = 0; a <= 59; ++a) {
                            if (a < 10) {
                                datatime.add("0" + String.format("%d", a));
                                continue;
                            }
                            datatime.add(String.format("%d", a));
                        }
                        break;
                    }
                }
                break block32;
            }
            switch (this.typeControl.toUpperCase()) {
                case "HOUR": {
                    for (int a = 0; a <= 23; ++a) {
                        if (a < 10) {
                            datatime.add("0" + String.format("%d", a));
                            continue;
                        }
                        datatime.add(String.format("%d", a));
                    }
                    break;
                }
                case "MINUTE": {
                    for (int a = 0; a <= 59; ++a) {
                        if (a < 10) {
                            datatime.add("0" + String.format("%d", a));
                            continue;
                        }
                        datatime.add(String.format("%d", a));
                    }
                    break;
                }
                case "SECOND": {
                    for (int a = 0; a <= 59; ++a) {
                        if (a < 10) {
                            datatime.add("0" + String.format("%d", a));
                            continue;
                        }
                        datatime.add(String.format("%d", a));
                    }
                    break;
                }
            }
        }
        this.mAdapter = new TimeAdapter(context, R.layout.mdtp_year_label_text_view, datatime);
        this.setAdapter((ListAdapter)this.mAdapter);
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        this.mController.tryVibrate();
        TextViewWithCircularIndicator clickedView = (TextViewWithCircularIndicator)view;
        if (clickedView != null) {
            if (clickedView != this.mSelectedView) {
                if (this.mSelectedView != null) {
                    this.mSelectedView.drawIndicator(false);
                    this.mSelectedView.requestLayout();
                }
                clickedView.drawIndicator(true);
                clickedView.requestLayout();
                this.mSelectedView = clickedView;
            }
            this.mController.onTimeSelected(TimePickerView.getTimeFromTextView(clickedView), this.typeControl.toUpperCase());
            this.mAdapter.notifyDataSetChanged();
        }
    }

    private static int getTimeFromTextView(TextView view) {
        return Integer.valueOf(view.getText().toString());
    }

    public void postSetSelectionCentered(int position) {
        this.postSetSelectionFromTop(position, this.mViewSize / 2 - this.mChildSize / 2);
    }

    public void postSetSelectionFromTop(final int position, final int offset) {
        this.post(new Runnable(){

            @Override
            public void run() {
                TimePickerView.this.setSelectionFromTop(position, offset);
                TimePickerView.this.requestLayout();
            }
        });
    }

    public int getFirstPositionOffset() {
        View firstChild = this.getChildAt(0);
        if (firstChild == null) {
            return 0;
        }
        return firstChild.getTop();
    }

    @Override
    public void onDateChanged() {
        this.mAdapter.notifyDataSetChanged();
        int rubah = 0;
        switch (this.typeControl.toUpperCase()) {
            case "HOUR": {
                if (!this.AMPM) {
                    rubah = this.mController.getSelectedDay().getHour() % 12;
                    break;
                }
                rubah = this.mController.getSelectedDay().getHour();
                break;
            }
            case "MINUTE": {
                rubah = this.mController.getSelectedDay().getMinute();
                break;
            }
            case "SECOND": {
                rubah = this.mController.getSelectedDay().getSecond();
            }
        }
        Log.e((String)"isi dari atas", (String)(" sisinya: " + rubah));
        this.postSetSelectionCentered(rubah);
    }

    public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        if (event.getEventType() == 4096) {
            event.setFromIndex(0);
            event.setToIndex(0);
        }
    }

    private class TimeAdapter
    extends ArrayAdapter<String> {
        public TimeAdapter(Context context, int resource, List<String> objects) {
            super(context, resource, objects);
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            TextViewWithCircularIndicator v = (TextViewWithCircularIndicator)super.getView(position, convertView, parent);
            v.setAccentColor(TimePickerView.this.mController.getAccentColor(), TimePickerView.this.mController.isThemeDark());
            v.requestLayout();
            int time = TimePickerView.getTimeFromTextView(v);
            Log.e((String)"isi time", (String)("isi" + time));
            boolean selected = false;
            switch (TimePickerView.this.typeControl.toUpperCase()) {
                case "HOUR": {
                    if (!TimePickerView.this.AMPM) {
                        selected = TimePickerView.this.mController.getSelectedDay().getHour() % 12 == time;
                        break;
                    }
                    selected = TimePickerView.this.mController.getSelectedDay().getHour() == time;
                    break;
                }
                case "MINUTE": {
                    selected = TimePickerView.this.mController.getSelectedDay().getMinute() == time;
                    break;
                }
                case "SECOND": {
                    selected = TimePickerView.this.mController.getSelectedDay().getSecond() == time;
                }
            }
            v.drawIndicator(selected);
            if (selected) {
                TimePickerView.this.mSelectedView = v;
            }
            return v;
        }
    }
}

