/*
 * Decompiled with CFR 0.152.
 */
package com.kenmeidearu.materialdatetimepicker.date;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.kenmeidearu.materialdatetimepicker.R;
import com.kenmeidearu.materialdatetimepicker.date.DatePickerController;
import com.kenmeidearu.materialdatetimepicker.date.DatePickerDialog;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class MonthPickerView
extends ListView
implements AdapterView.OnItemClickListener,
DatePickerDialog.OnDateChangedListener {
    private static final String TAG = "MonthPickerView";
    private final DatePickerController mController;
    private MonthAdapter mAdapter;
    private int mViewSize;
    private int mChildSize;
    private Calendar minDate;
    private Calendar maxDate;
    private TextView mSelectedViewT;

    public MonthPickerView(Context context, DatePickerController controller) {
        super(context);
        this.mController = controller;
        this.mController.registerOnDateChangedListener(this);
        ViewGroup.LayoutParams frame = new ViewGroup.LayoutParams(-1, -2);
        this.setLayoutParams(frame);
        Resources res = context.getResources();
        this.mViewSize = res.getDimensionPixelOffset(R.dimen.mdtp_date_picker_view_animator_height);
        this.mChildSize = res.getDimensionPixelOffset(R.dimen.mdtp_year_label_height);
        this.setVerticalFadingEdgeEnabled(true);
        this.setFadingEdgeLength(this.mChildSize / 3);
        this.init(context);
        this.setOnItemClickListener(this);
        this.setSelector((Drawable)new StateListDrawable());
        this.setDividerHeight(0);
        this.onDateChanged();
    }

    private void init(Context context) {
        String[] months = new DateFormatSymbols().getMonths();
        ArrayList<String> monthsList = new ArrayList<String>();
        for (int month = this.mController.getMinMonth(); month <= this.mController.getMaxMonth(); ++month) {
            monthsList.add(months[month]);
        }
        this.mAdapter = new MonthAdapter(context, R.layout.mdtp_year_label_text_view, monthsList);
        this.setAdapter((ListAdapter)this.mAdapter);
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        this.mController.tryVibrate();
        TextView clickedView = (TextView)view;
        if (clickedView != null) {
            this.mController.onMonthSelected(MonthPickerView.getMonthFromTextView(clickedView));
            this.mAdapter.notifyDataSetChanged();
        }
    }

    private static int getMonthFromTextView(TextView view) {
        String[] months = new DateFormatSymbols().getMonths();
        int index = -1;
        for (int i = 0; i < months.length; ++i) {
            if (!months[i].equals(view.getText().toString())) continue;
            index = i;
            break;
        }
        return index;
    }

    public void postSetSelectionCentered(int position) {
        this.postSetSelectionFromTop(position, this.mViewSize / 2 - this.mChildSize / 2);
    }

    public void postSetSelectionFromTop(final int position, final int offset) {
        this.post(new Runnable(){

            @Override
            public void run() {
                MonthPickerView.this.setSelectionFromTop(position, offset);
                MonthPickerView.this.requestLayout();
            }
        });
    }

    public int getFirstPositionOffset() {
        View firstChild = this.getChildAt(0);
        if (firstChild == null) {
            return 0;
        }
        return firstChild.getTop();
    }

    @Override
    public void onDateChanged() {
        this.mAdapter.notifyDataSetChanged();
        this.postSetSelectionCentered(this.mController.getSelectedDay().month);
    }

    public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        if (event.getEventType() == 4096) {
            event.setFromIndex(0);
            event.setToIndex(0);
        }
    }

    private class MonthAdapter
    extends ArrayAdapter<String> {
        public MonthAdapter(Context context, int resource, List<String> objects) {
            super(context, resource, objects);
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            boolean selected;
            TextView v = (TextView)super.getView(position, convertView, parent);
            int month = MonthPickerView.getMonthFromTextView(v);
            boolean bl = selected = ((MonthPickerView)MonthPickerView.this).mController.getSelectedDay().month == month;
            if (selected) {
                v.setBackgroundResource(R.color.mdtp_accent_color);
                MonthPickerView.this.mSelectedViewT = v;
            } else {
                v.setBackgroundResource(0);
            }
            return v;
        }
    }
}

