/*
 * Decompiled with CFR 0.152.
 */
package net.glxn.qrgen.android;

import android.graphics.Bitmap;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import net.glxn.qrgen.android.MatrixToImageConfig;
import net.glxn.qrgen.android.MatrixToImageWriter;
import net.glxn.qrgen.core.AbstractQRCode;
import net.glxn.qrgen.core.exception.QRGenerationException;
import net.glxn.qrgen.core.image.ImageType;
import net.glxn.qrgen.core.scheme.Schema;

public class QRCode
extends AbstractQRCode {
    protected final String text;
    private MatrixToImageConfig matrixToImageConfig = new MatrixToImageConfig();

    protected QRCode(String text) {
        this.text = text;
        this.qrWriter = new QRCodeWriter();
    }

    public static QRCode from(String text) {
        return new QRCode(text);
    }

    public static QRCode from(Schema schema) {
        return new QRCode(schema.generateString());
    }

    public QRCode to(ImageType imageType) {
        this.imageType = imageType;
        return this;
    }

    public QRCode withColor(int onColor, int offColor) {
        this.matrixToImageConfig = new MatrixToImageConfig(onColor, offColor);
        return this;
    }

    public QRCode withSize(int width, int height) {
        this.width = width;
        this.height = height;
        return this;
    }

    public QRCode withCharset(String charset) {
        return this.withHint(EncodeHintType.CHARACTER_SET, charset);
    }

    public QRCode withErrorCorrection(ErrorCorrectionLevel level) {
        return this.withHint(EncodeHintType.ERROR_CORRECTION, level);
    }

    public QRCode withHint(EncodeHintType hintType, Object value) {
        this.hints.put(hintType, value);
        return this;
    }

    public Bitmap bitmap() {
        try {
            return MatrixToImageWriter.toBitmap(this.createMatrix(this.text), this.matrixToImageConfig);
        }
        catch (WriterException e) {
            throw new QRGenerationException("Failed to create QR image from text due to underlying exception", (Throwable)e);
        }
    }

    public File file() {
        File file;
        try {
            file = this.createTempFile();
            MatrixToImageWriter.writeToFile(this.createMatrix(this.text), this.imageType.toString(), file, this.matrixToImageConfig);
        }
        catch (Exception e) {
            throw new QRGenerationException("Failed to create QR image from text due to underlying exception", (Throwable)e);
        }
        return file;
    }

    public File file(String name) {
        File file;
        try {
            file = this.createTempFile(name);
            MatrixToImageWriter.writeToFile(this.createMatrix(this.text), this.imageType.toString(), file, this.matrixToImageConfig);
        }
        catch (Exception e) {
            throw new QRGenerationException("Failed to create QR image from text due to underlying exception", (Throwable)e);
        }
        return file;
    }

    protected void writeToStream(OutputStream stream) throws IOException, WriterException {
        MatrixToImageWriter.writeToStream(this.createMatrix(this.text), this.imageType.toString(), stream, this.matrixToImageConfig);
    }
}

