/*
 * Decompiled with CFR 0.152.
 */
package com.github.kayvannj.permission_utils;

import android.app.Activity;
import android.content.Context;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.Fragment;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import com.github.kayvannj.permission_utils.Func;
import com.github.kayvannj.permission_utils.Func2;
import com.github.kayvannj.permission_utils.Func3;
import com.github.kayvannj.permission_utils.SinglePermission;
import java.util.ArrayList;

public class PermissionUtil {
    public static PermissionObject with(AppCompatActivity activity) {
        return new PermissionObject(activity);
    }

    public static PermissionObject with(Fragment fragment) {
        return new PermissionObject(fragment);
    }

    public static class PermissionRequestObject {
        private static final String TAG = PermissionObject.class.getSimpleName();
        private AppCompatActivity mActivity;
        private Func mDenyFunc;
        private Fragment mFragment;
        private Func mGrantFunc;
        private String[] mPermissionNames;
        private ArrayList<SinglePermission> mPermissionsWeDontHave;
        private Func3 mRationalFunc;
        private int mRequestCode;
        private Func2 mResultFunc;

        public PermissionRequestObject(AppCompatActivity activity, String[] permissionNames) {
            this.mActivity = activity;
            this.mPermissionNames = permissionNames;
        }

        public PermissionRequestObject(Fragment fragment, String[] permissionNames) {
            this.mFragment = fragment;
            this.mPermissionNames = permissionNames;
        }

        public PermissionRequestObject ask(int reqCode) {
            this.mRequestCode = reqCode;
            int length = this.mPermissionNames.length;
            this.mPermissionsWeDontHave = new ArrayList(length);
            for (String mPermissionName : this.mPermissionNames) {
                this.mPermissionsWeDontHave.add(new SinglePermission(mPermissionName));
            }
            if (this.needToAsk()) {
                Log.i((String)TAG, (String)"Asking for permission");
                if (this.mActivity != null) {
                    ActivityCompat.requestPermissions((Activity)this.mActivity, (String[])this.mPermissionNames, (int)reqCode);
                } else {
                    this.mFragment.requestPermissions(this.mPermissionNames, reqCode);
                }
            } else {
                Log.i((String)TAG, (String)"No need to ask for permission");
                if (this.mGrantFunc != null) {
                    this.mGrantFunc.call();
                }
            }
            return this;
        }

        private boolean needToAsk() {
            int i;
            ArrayList<SinglePermission> neededPermissions = new ArrayList<SinglePermission>(this.mPermissionsWeDontHave);
            for (i = 0; i < this.mPermissionsWeDontHave.size(); ++i) {
                SinglePermission perm = this.mPermissionsWeDontHave.get(i);
                int checkRes = this.mActivity != null ? ContextCompat.checkSelfPermission((Context)this.mActivity, (String)perm.getPermissionName()) : ContextCompat.checkSelfPermission((Context)this.mFragment.getContext(), (String)perm.getPermissionName());
                if (checkRes == 0) {
                    neededPermissions.remove(perm);
                    continue;
                }
                boolean shouldShowRequestPermissionRationale = this.mActivity != null ? ActivityCompat.shouldShowRequestPermissionRationale((Activity)this.mActivity, (String)perm.getPermissionName()) : this.mFragment.shouldShowRequestPermissionRationale(perm.getPermissionName());
                if (!shouldShowRequestPermissionRationale) continue;
                perm.setRationalNeeded(true);
            }
            this.mPermissionsWeDontHave = neededPermissions;
            this.mPermissionNames = new String[this.mPermissionsWeDontHave.size()];
            for (i = 0; i < this.mPermissionsWeDontHave.size(); ++i) {
                this.mPermissionNames[i] = this.mPermissionsWeDontHave.get(i).getPermissionName();
            }
            return this.mPermissionsWeDontHave.size() != 0;
        }

        public PermissionRequestObject onRational(Func3 rationalFunc) {
            this.mRationalFunc = rationalFunc;
            return this;
        }

        public PermissionRequestObject onAllGranted(Func grantFunc) {
            this.mGrantFunc = grantFunc;
            return this;
        }

        public PermissionRequestObject onAnyDenied(Func denyFunc) {
            this.mDenyFunc = denyFunc;
            return this;
        }

        public PermissionRequestObject onResult(Func2 resultFunc) {
            this.mResultFunc = resultFunc;
            return this;
        }

        public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
            if (this.mRequestCode == requestCode) {
                if (this.mResultFunc != null) {
                    Log.i((String)TAG, (String)"Calling Results Func");
                    this.mResultFunc.call(requestCode, permissions, grantResults);
                    return;
                }
                for (int i = 0; i < permissions.length; ++i) {
                    if (grantResults[i] != -1) continue;
                    if (this.mPermissionsWeDontHave.get(i).isRationalNeeded() && this.mRationalFunc != null) {
                        Log.i((String)TAG, (String)"Calling Rational Func");
                        this.mRationalFunc.call(this.mPermissionsWeDontHave.get(i).getPermissionName());
                    } else if (this.mDenyFunc != null) {
                        Log.i((String)TAG, (String)"Calling Deny Func");
                        this.mDenyFunc.call();
                    } else {
                        Log.e((String)TAG, (String)"NUll DENY FUNCTIONS");
                    }
                    return;
                }
                if (this.mGrantFunc != null) {
                    Log.i((String)TAG, (String)"Calling Grant Func");
                    this.mGrantFunc.call();
                } else {
                    Log.e((String)TAG, (String)"NUll GRANT FUNCTIONS");
                }
            }
        }
    }

    public static class PermissionObject {
        private AppCompatActivity mActivity;
        private Fragment mFragment;

        PermissionObject(AppCompatActivity activity) {
            this.mActivity = activity;
        }

        PermissionObject(Fragment fragment) {
            this.mFragment = fragment;
        }

        public boolean has(String permissionName) {
            int permissionCheck = this.mActivity != null ? ContextCompat.checkSelfPermission((Context)this.mActivity, (String)permissionName) : ContextCompat.checkSelfPermission((Context)this.mFragment.getContext(), (String)permissionName);
            return permissionCheck == 0;
        }

        public PermissionRequestObject request(String permissionName) {
            if (this.mActivity != null) {
                return new PermissionRequestObject(this.mActivity, new String[]{permissionName});
            }
            return new PermissionRequestObject(this.mFragment, new String[]{permissionName});
        }

        public PermissionRequestObject request(String ... permissionNames) {
            if (this.mActivity != null) {
                return new PermissionRequestObject(this.mActivity, permissionNames);
            }
            return new PermissionRequestObject(this.mFragment, permissionNames);
        }
    }
}

