/*
 * Decompiled with CFR 0.152.
 */
package com.kavenegar.sdk;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.kavenegar.sdk.enums.MessageType;
import com.kavenegar.sdk.excepctions.ApiException;
import com.kavenegar.sdk.excepctions.BaseException;
import com.kavenegar.sdk.excepctions.HttpException;
import com.kavenegar.sdk.models.AccountConfigResult;
import com.kavenegar.sdk.models.AccountInfoResult;
import com.kavenegar.sdk.models.CountInboxResult;
import com.kavenegar.sdk.models.CountOutboxResult;
import com.kavenegar.sdk.models.CountPostalCodeResult;
import com.kavenegar.sdk.models.ReceiveResult;
import com.kavenegar.sdk.models.SendResult;
import com.kavenegar.sdk.models.StatusLocalMessageIdResult;
import com.kavenegar.sdk.models.StatusResult;
import com.kavenegar.sdk.utils.PairValue;
import com.kavenegar.sdk.utils.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class KavenegarApi {
    static final String API_PATH = "%s://api.kavenegar.com/v1/%s/%s.json";
    private String apiKey;
    private Boolean safe;

    public KavenegarApi(String apiKey) {
        this.apiKey = apiKey;
        this.safe = Boolean.FALSE;
    }

    public KavenegarApi(String apiKey, Boolean safe) {
        this.apiKey = apiKey;
        this.safe = safe;
    }

    private String getApiPath(String method) {
        if (this.safe == Boolean.TRUE) {
            return String.format(API_PATH, "https", this.apiKey, method);
        }
        return String.format(API_PATH, "http", this.apiKey, method);
    }

    public UrlEncodedFormEntity createParams(Object ... params) {
        try {
            ArrayList<BasicNameValuePair> formparams = new ArrayList<BasicNameValuePair>();
            for (int i = 0; i < params.length; i += 2) {
                String key = params[i].toString();
                Object value = params[i + 1];
                if (value == null) continue;
                formparams.add(new BasicNameValuePair(key, value.toString()));
            }
            return new UrlEncodedFormEntity(formparams, "UTF-8");
        }
        catch (Exception ex) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JsonElement execute(String path, Object ... params) throws BaseException {
        UrlEncodedFormEntity parameters = this.createParams(params);
        CloseableHttpClient client = HttpClients.createDefault();
        HttpPost post = new HttpPost(path);
        post.setEntity((HttpEntity)parameters);
        try (CloseableHttpResponse response = client.execute((HttpUriRequest)post);){
            int httpCode = response.getStatusLine().getStatusCode();
            if (httpCode != 200) {
                throw new HttpException("Http request exception , code : " + httpCode, httpCode);
            }
            String entity = EntityUtils.toString((HttpEntity)response.getEntity());
            JsonObject json = new JsonParser().parse(entity).getAsJsonObject();
            JsonObject returnJson = json.get("return").getAsJsonObject();
            if (returnJson.get("status").getAsInt() != 200) {
                throw new ApiException(returnJson.get("message").getAsString(), returnJson.get("status").getAsInt());
            }
            JsonElement jsonElement = json.get("entries");
            return jsonElement;
        }
        catch (IOException e1) {
            throw new HttpException("Http Request Exception", 0);
        }
        catch (ApiException e2) {
            throw e2;
        }
    }

    public List<SendResult> send(String sender, List<String> receptors, String message, MessageType type, long date, List<String> localIds) throws BaseException {
        JsonArray entry = this.execute(this.getApiPath("sms/send"), "sender", sender, "receptor", StringUtils.join(",", receptors), "message", message, "type", type.getValue(), "date", date, "localid", localIds == null ? "" : StringUtils.join(",", localIds)).getAsJsonArray();
        ArrayList<SendResult> list = new ArrayList<SendResult>();
        for (int i = 0; i < entry.size(); ++i) {
            JsonObject json = entry.get(i).getAsJsonObject();
            SendResult result = new SendResult(json);
            list.add(result);
        }
        return list;
    }

    public SendResult send(String sender, String receptor, String message) throws BaseException {
        return this.send(sender, receptor, message, MessageType.MobileMemory, 0L);
    }

    public SendResult send(String sender, String receptor, String message, MessageType type, long date) throws BaseException {
        return this.send(sender, Arrays.asList(receptor), message, type, date).get(0);
    }

    public List<SendResult> send(String sender, List<String> receptors, String message) throws BaseException {
        return this.send(sender, receptors, message, MessageType.MobileMemory, 0L);
    }

    public List<SendResult> send(String sender, List<String> receptors, String message, MessageType type, long date) throws BaseException {
        return this.send(sender, receptors, message, type, date, null);
    }

    public SendResult send(String sender, String receptor, String message, MessageType type, long date, String localId) throws BaseException {
        List<String> receptors = Arrays.asList(receptor);
        List<String> localIds = Arrays.asList(localId);
        return this.send(sender, receptors, message, MessageType.MobileMemory, 0L, localIds).get(0);
    }

    public SendResult send(String sender, String receptor, String message, String localId) throws BaseException {
        return this.send(sender, receptor, message, MessageType.MobileMemory, 0L, localId);
    }

    public List<SendResult> sendArray(List<String> senders, List<String> receptors, List<String> messages, List<MessageType> types, long date, List<String> localIds) throws BaseException {
        String path = this.getApiPath("sms/sendarray");
        JsonArray jsonReceptors = new JsonArray();
        JsonArray jsonSenders = new JsonArray();
        JsonArray jsonMessages = new JsonArray();
        JsonArray jsonTypes = new JsonArray();
        for (int i = 0; i < messages.size(); ++i) {
            jsonReceptors.add((JsonElement)new JsonPrimitive(receptors.get(i)));
            jsonSenders.add((JsonElement)new JsonPrimitive(senders.get(i)));
            jsonMessages.add((JsonElement)new JsonPrimitive(messages.get(i)));
            jsonTypes.add((JsonElement)new JsonPrimitive((Number)types.get(i).getValue()));
        }
        JsonArray entry = this.execute(path, "sender", jsonSenders.toString(), "receptor", jsonReceptors.toString(), "message", jsonMessages.toString(), "date", date, "type", jsonTypes.toString(), "localids", localIds).getAsJsonArray();
        ArrayList<SendResult> list = new ArrayList<SendResult>();
        for (int i = 0; i < entry.size(); ++i) {
            JsonObject json = entry.get(i).getAsJsonObject();
            SendResult result = new SendResult(json);
            list.add(result);
        }
        return list;
    }

    public List<SendResult> sendArray(List<String> senders, List<String> receptors, List<String> messages) throws BaseException {
        return this.sendArray(senders, receptors, messages, null);
    }

    public List<SendResult> sendArray(List<String> senders, List<String> receptors, List<String> messages, String localId) throws BaseException {
        ArrayList<MessageType> types = new ArrayList<MessageType>();
        ArrayList<String> localIds = new ArrayList<String>();
        for (int i = 0; i < receptors.size(); ++i) {
            types.add(MessageType.MobileMemory);
            localIds.add(localId);
        }
        return this.sendArray(senders, receptors, messages, types, 0L, localIds);
    }

    public List<SendResult> sendArray(List<String> senders, List<String> receptors, List<String> messages, List<MessageType> types, long date, String localId) throws BaseException {
        ArrayList<String> localIds = new ArrayList<String>();
        for (int i = 0; i < receptors.size(); ++i) {
            localIds.add(localId);
        }
        return this.sendArray(senders, receptors, messages, types, date, localIds);
    }

    public List<SendResult> sendArray(String sender, List<String> receptors, List<String> messages) throws BaseException {
        return this.sendArray(sender, receptors, messages, null);
    }

    public List<SendResult> sendArray(String sender, List<String> receptors, List<String> messages, String localId) throws BaseException {
        ArrayList<MessageType> types = new ArrayList<MessageType>();
        for (int i = 0; i < types.size(); ++i) {
            types.add(MessageType.MobileMemory);
        }
        ArrayList<String> senders = new ArrayList<String>();
        for (int i = 0; i < receptors.size(); ++i) {
            senders.add(sender);
        }
        return this.sendArray(senders, receptors, messages, types, 0L, localId);
    }

    public List<SendResult> sendArray(String sender, List<String> receptors, List<String> messages, List<MessageType> types, long date, String localId) throws BaseException {
        ArrayList<String> senders = new ArrayList<String>();
        ArrayList<String> localIds = new ArrayList<String>();
        for (int i = 0; i < receptors.size(); ++i) {
            senders.add(sender);
            localIds.add(localId);
        }
        return this.sendArray(senders, receptors, messages, types, date, localIds);
    }

    public List<StatusResult> status(List<Long> messageId) throws BaseException {
        String path = this.getApiPath("sms/status");
        String id = StringUtils.join(",", messageId);
        JsonArray array = this.execute(path, "messageid", id).getAsJsonArray();
        ArrayList<StatusResult> list = new ArrayList<StatusResult>();
        for (int i = 0; i < array.size(); ++i) {
            JsonObject json = array.get(i).getAsJsonObject();
            StatusResult result = new StatusResult(json);
            list.add(result);
        }
        return list;
    }

    public StatusResult status(Long messageId) throws BaseException {
        return this.status(Arrays.asList(messageId)).get(0);
    }

    public List<StatusLocalMessageIdResult> statusLocalMessageId(List<Long> localIds) throws BaseException {
        String path = this.getApiPath("sms/statuslocalmessageid");
        String id = StringUtils.join(",", localIds);
        JsonArray array = this.execute(path, "localid", id).getAsJsonArray();
        ArrayList<StatusLocalMessageIdResult> list = new ArrayList<StatusLocalMessageIdResult>();
        for (int i = 0; i < array.size(); ++i) {
            JsonObject json = array.get(i).getAsJsonObject();
            list.add(new StatusLocalMessageIdResult(json));
        }
        return list;
    }

    public StatusLocalMessageIdResult statusLocalMessageId(Long localId) throws BaseException {
        return this.statusLocalMessageId(Arrays.asList(localId)).get(0);
    }

    public List<SendResult> select(List<Long> ids) throws BaseException {
        String path = this.getApiPath("sms/select");
        String massageids = StringUtils.join(",", ids);
        JsonArray array = this.execute(path, "messageid", massageids).getAsJsonArray();
        ArrayList<SendResult> list = new ArrayList<SendResult>();
        for (int i = 0; i < array.size(); ++i) {
            JsonObject json = array.get(i).getAsJsonObject();
            SendResult result = new SendResult(json);
            list.add(result);
        }
        return list;
    }

    public SendResult select(long messageId) throws BaseException {
        ArrayList<Long> messageIds = new ArrayList<Long>();
        messageIds.add(messageId);
        return this.select(messageIds).get(0);
    }

    public List<SendResult> selectOutbox(long startDate, long endDate, String sender) throws BaseException {
        String path = this.getApiPath("sms/selectoutbox");
        JsonArray array = this.execute(path, "startdate", startDate, "enddate", endDate, "sender", sender).getAsJsonArray();
        ArrayList<SendResult> list = new ArrayList<SendResult>();
        for (int i = 0; i < array.size(); ++i) {
            JsonObject json = array.get(i).getAsJsonObject();
            list.add(new SendResult(json));
        }
        return list;
    }

    public List<SendResult> selectOutbox(long startDate) throws BaseException {
        return this.selectOutbox(startDate, 0L, "");
    }

    public List<SendResult> selectOutbox(long startDate, long endDate) throws BaseException {
        return this.selectOutbox(startDate, endDate, "");
    }

    public List<SendResult> latestOutbox(Long pageSize, String sender) throws BaseException {
        String path = this.getApiPath("sms/latestoutbox");
        JsonArray array = this.execute(path, "pagesize", pageSize, "sender", sender).getAsJsonArray();
        ArrayList<SendResult> list = new ArrayList<SendResult>();
        for (int i = 0; i < array.size(); ++i) {
            JsonObject json = array.get(i).getAsJsonObject();
            SendResult result = new SendResult(json);
            list.add(result);
        }
        return list;
    }

    public List<SendResult> latestOutbox() throws BaseException {
        return this.latestOutbox(3000L, "");
    }

    public List<SendResult> latestOutbox(Long pageSize) throws BaseException {
        return this.latestOutbox(pageSize, "");
    }

    public CountOutboxResult countOutbox(long startDate, long endDate, int status) throws BaseException {
        String path = this.getApiPath("sms/countoutbox");
        JsonObject entry = this.execute(path, "startdate", startDate, "enddate", endDate, "status", status).getAsJsonArray().get(0).getAsJsonObject();
        return new CountOutboxResult(entry);
    }

    public CountOutboxResult countOutbox(long startDate) throws BaseException {
        return this.countOutbox(startDate, 0L, 0);
    }

    public CountOutboxResult countOutbox(long startDate, long endDate) throws BaseException {
        return this.countOutbox(startDate, endDate, 0);
    }

    public List<StatusResult> cancel(List<Long> messageIds) throws BaseException {
        String path = this.getApiPath("sms/cancel");
        String id = StringUtils.join(",", messageIds);
        JsonArray array = this.execute(path, "messageid", id).getAsJsonArray();
        ArrayList<StatusResult> list = new ArrayList<StatusResult>();
        for (int i = 0; i < array.size(); ++i) {
            JsonObject json = array.get(i).getAsJsonObject();
            StatusResult statusResult = new StatusResult(json);
        }
        return list;
    }

    public StatusResult cancel(Long messageId) throws BaseException {
        return this.cancel(Arrays.asList(messageId)).get(0);
    }

    public List<ReceiveResult> receive(String lineNumber, int isRead) throws BaseException {
        String path = this.getApiPath("sms/receive");
        JsonElement res = this.execute(path, "linenumber", lineNumber, "isread", isRead);
        if (res.isJsonNull()) {
            return new ArrayList<ReceiveResult>();
        }
        JsonArray array = res.getAsJsonArray();
        ArrayList<ReceiveResult> list = new ArrayList<ReceiveResult>();
        for (int i = 0; i < array.size(); ++i) {
            JsonObject json = array.get(i).getAsJsonObject();
            list.add(new ReceiveResult(json));
        }
        return list;
    }

    public CountInboxResult countInbox(long startDate, long endDate, String lineNumber, int isRead) throws BaseException {
        String path = this.getApiPath("sms/countinbox");
        JsonObject entry = this.execute(path, "startdate", startDate, "enddate", endDate, "linenumber", lineNumber, "isread", isRead).getAsJsonArray().get(0).getAsJsonObject();
        return new CountInboxResult(entry);
    }

    public CountInboxResult countInbox(long startDate, String lineNumber) throws BaseException {
        return this.countInbox(startDate, 0L, lineNumber, 0);
    }

    public CountInboxResult countInbox(long startDate, long endDate, String lineNumber) throws BaseException {
        return this.countInbox(startDate, endDate, lineNumber, 0);
    }

    public List<SendResult> sendByPostalCode(long postalCode, String sender, String message, long mciStartIndex, long mciCount, long mtnStartIndex, long mtnCount, long date) throws BaseException {
        String path = this.getApiPath("sms/sendpostalcode");
        JsonArray entry = this.execute(path, "postalcode", postalCode, "sender", sender, "message", message, "mcistartIndex", mciStartIndex, "mcicount", mciCount, "mtnstartindex", mtnStartIndex, "mtncount", mtnCount, "date", date).getAsJsonArray();
        ArrayList<SendResult> list = new ArrayList<SendResult>();
        for (int i = 0; i < entry.size(); ++i) {
            JsonObject json = entry.get(i).getAsJsonObject();
            SendResult result = new SendResult(json);
            list.add(result);
        }
        return list;
    }

    public List<SendResult> sendByPostalCode(long postalCode, String sender, String message, long mciStartIndex, long mciCount, long mtnStartIndex, long mtnCount) throws BaseException {
        return this.sendByPostalCode(postalCode, sender, message, mciStartIndex, mciCount, mtnStartIndex, mtnCount, 0L);
    }

    public List<CountPostalCodeResult> countPostalCode(Long postalCode) throws BaseException {
        String path = this.getApiPath("sms/countpostalcode");
        JsonArray array = this.execute(path, "postalcode", postalCode).getAsJsonArray();
        ArrayList<CountPostalCodeResult> list = new ArrayList<CountPostalCodeResult>();
        for (int i = 0; i < array.size(); ++i) {
            JsonObject entry = array.get(i).getAsJsonObject();
            list.add(new CountPostalCodeResult(entry));
        }
        return list;
    }

    public AccountInfoResult accountInfo() throws BaseException {
        String path = this.getApiPath("account/info");
        JsonObject json = this.execute(path, new Object[0]).getAsJsonObject();
        return new AccountInfoResult(json);
    }

    public AccountConfigResult accountConfig(String apiLogs, String dailyReport, String debugMode, String defaultSender, int minCreditAlarm, String resendFailed) throws BaseException {
        String path = this.getApiPath("account/config");
        JsonObject json = this.execute(path, "apilogs", dailyReport, "dailyreport", debugMode, "debugmode", debugMode, "defaultsender", defaultSender, "mincreditalarm", minCreditAlarm, "mincreditalarm", resendFailed).getAsJsonObject();
        return new AccountConfigResult(json);
    }

    public SendResult verifyLookup(String receptor, String token, String token2, String token3, String template) throws BaseException {
        String path = this.getApiPath("verify/lookup");
        JsonArray array = this.execute(path, "receptor", receptor, "token", token, "token2", token2, "token3", token3, "template", template).getAsJsonArray();
        JsonObject json = array.get(0).getAsJsonObject();
        return new SendResult(json);
    }

    public SendResult verifyLookup(String receptor, String token, String token2, String token3, String template, List<PairValue> params) throws BaseException {
        String path = this.getApiPath("verify/lookup");
        String token10 = null;
        String token20 = null;
        for (PairValue Key : params) {
            if (null == Key.getKey()) continue;
            switch (Key.getKey()) {
                case "token10": {
                    token10 = Key.getValue();
                    break;
                }
                case "token20": {
                    token20 = Key.getValue();
                }
            }
        }
        JsonArray array = this.execute(path, "receptor", receptor, "token", token, "token2", token2, "token3", token3, "template", template, "token10", token10, "token20", token20).getAsJsonArray();
        JsonObject json = array.get(0).getAsJsonObject();
        return new SendResult(json);
    }

    public SendResult verifyLookup(String receptor, String token, String template) throws BaseException {
        return this.verifyLookup(receptor, token, "", "", template);
    }

    public List<SendResult> CallMakeTTS(String message, List<String> receptors, Long date, List<String> localIds) throws BaseException {
        JsonArray entry = this.execute(this.getApiPath("call/maketts"), "receptor", StringUtils.join(",", receptors), "message", message, "date", date, "localid", localIds == null ? "" : StringUtils.join(",", localIds)).getAsJsonArray();
        ArrayList<SendResult> list = new ArrayList<SendResult>();
        for (int i = 0; i < entry.size(); ++i) {
            JsonObject json = entry.get(i).getAsJsonObject();
            SendResult result = new SendResult(json);
            list.add(result);
        }
        return list;
    }

    public SendResult CallMakeTTS(String message, String receptor) throws BaseException {
        ArrayList<String> receptors = new ArrayList<String>();
        receptors.add(receptor);
        return this.CallMakeTTS(message, receptors).get(0);
    }

    public List<SendResult> CallMakeTTS(String message, List<String> receptor) throws BaseException {
        return this.CallMakeTTS(message, receptor, null, null);
    }

    public List<SendResult> CallMakeTTS(String message, String receptor, Long date) throws BaseException {
        ArrayList<String> receptors = new ArrayList<String>();
        receptors.add(receptor);
        return this.CallMakeTTS(message, receptors, date);
    }

    public List<SendResult> CallMakeTTS(String message, List<String> receptor, Long date) throws BaseException {
        return this.CallMakeTTS(message, receptor, date, null);
    }

    public List<SendResult> CallMakeTTS(String message, List<String> receptor, List<String> localId) throws BaseException {
        return this.CallMakeTTS(message, receptor, null, localId);
    }

    public List<SendResult> CallMakeTTS(String message, List<String> receptor, String localId) throws BaseException {
        ArrayList<String> localIds = new ArrayList<String>();
        localIds.add(localId);
        return this.CallMakeTTS(message, receptor, null, localIds);
    }
}

