/*
 * Decompiled with CFR 0.152.
 */
package com.github.karthyks.runtimepermissions.googleapi;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import com.github.karthyks.runtimepermissions.PermissionActivity;
import com.github.karthyks.runtimepermissions.R;
import com.github.karthyks.runtimepermissions.googleapi.GoogleClient;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.location.LocationSettingsRequest;
import com.google.android.gms.location.LocationSettingsResult;
import com.google.android.gms.location.LocationSettingsStates;

public class LocationSettingsActivity
extends AppCompatActivity
implements GoogleClient.GoogleClientCallback {
    public static final int REQUEST_LOCATION_SETTINGS = 512;
    private static final int REQUEST_CHECK_SETTINGS = 513;
    public static final String EXTRAS_LOCATION_REQUEST = "extras_location_settings_api";
    public static final String EXTRAS_ALWAYS_SHOW_REQUEST = "extras_always_show_request";
    public static final String EXTRAS_LOCATION_NEEDBLE = "extras_location_needble";
    private GoogleClient googleClient;
    private LocationRequest locationRequest;
    private boolean alwaysShowRequest;
    private boolean needBleRequest;

    public static Intent getInstance(Context context, LocationRequest request, boolean alwaysShow, boolean needBle) {
        Intent intent = new Intent(context, LocationSettingsActivity.class);
        intent.putExtra(EXTRAS_LOCATION_REQUEST, (Parcelable)request);
        intent.putExtra(EXTRAS_ALWAYS_SHOW_REQUEST, alwaysShow);
        intent.putExtra(EXTRAS_LOCATION_NEEDBLE, needBle);
        return intent;
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_run_time_permission);
        this.locationRequest = (LocationRequest)this.getIntent().getParcelableExtra(EXTRAS_LOCATION_REQUEST);
        this.alwaysShowRequest = this.getIntent().getBooleanExtra(EXTRAS_ALWAYS_SHOW_REQUEST, true);
        this.needBleRequest = this.getIntent().getBooleanExtra(EXTRAS_LOCATION_NEEDBLE, false);
        this.connectGoogleClient();
    }

    private void connectGoogleClient() {
        this.googleClient = new GoogleClient((Context)this, (Api<Api.ApiOptions.NoOptions>)LocationServices.API);
        this.googleClient.setGoogleClientCallback(this);
        this.googleClient.connectGoogleApi();
    }

    private void endActivity(int code) {
        this.setResult(code);
        this.finish();
    }

    public void checkLocationRequest(GoogleApiClient googleApiClient, LocationSettingsRequest.Builder builder) {
        PendingResult result = LocationServices.SettingsApi.checkLocationSettings(googleApiClient, builder.build());
        result.setResultCallback((ResultCallback)new ResultCallback<LocationSettingsResult>(){

            public void onResult(@NonNull LocationSettingsResult locationSettingsResult) {
                Status status = locationSettingsResult.getStatus();
                LocationSettingsStates states = locationSettingsResult.getLocationSettingsStates();
                switch (status.getStatusCode()) {
                    case 0: {
                        LocationSettingsActivity.this.endActivity(-1);
                        break;
                    }
                    case 6: {
                        try {
                            status.startResolutionForResult((Activity)LocationSettingsActivity.this, 513);
                        }
                        catch (IntentSender.SendIntentException e) {
                            Log.d((String)PermissionActivity.TAG, (String)("onResult: " + e.getMessage()));
                            LocationSettingsActivity.this.endActivity(0);
                        }
                        break;
                    }
                    case 8502: {
                        LocationSettingsActivity.this.endActivity(0);
                    }
                }
            }
        });
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 513) {
            this.endActivity(resultCode);
        }
    }

    @Override
    public void onConnected() {
        LocationSettingsRequest.Builder builder = new LocationSettingsRequest.Builder().addLocationRequest(this.locationRequest);
        builder.setAlwaysShow(this.alwaysShowRequest);
        builder.setNeedBle(this.needBleRequest);
        this.checkLocationRequest(this.googleClient.getGoogleApiClient(), builder);
    }

    @Override
    public void onConnectionSuspended() {
        this.endActivity(0);
    }

    @Override
    public void onConnectionFailed() {
        this.endActivity(0);
    }

    protected void onDestroy() {
        this.googleClient.disconnectGoogleApi();
        super.onDestroy();
    }
}

