/*
 * Decompiled with CFR 0.152.
 */
package com.github.karthyks.runtimepermissions.prefs;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;

public class SharedPrefUtil {
    public static final String PREF_FILE_NAME = "runtime_permission_checker";
    public static final String LOCATION = "location";
    public static final String CONTACTS = "contacts";
    public static final String CALENDAR = "calendar";
    public static final String CAMERA = "camera";
    public static final String MICROPHONE = "microphone";
    public static final String PHONE = "phone";
    public static final String SENSORS = "sensors";
    public static final String SMS = "sms";
    public static final String STORAGE = "storage";

    public static void putInSharedPref(Context context, int permissionCode, boolean isDenied) {
        SharedPreferences.Editor sharedPref = context.getSharedPreferences(PREF_FILE_NAME, 0).edit();
        switch (permissionCode) {
            case 427: {
                sharedPref.putBoolean(CONTACTS, isDenied);
                break;
            }
            case 429: {
                sharedPref.putBoolean(CALENDAR, isDenied);
                break;
            }
            case 426: {
                sharedPref.putBoolean(CAMERA, isDenied);
                break;
            }
            case 428: {
                sharedPref.putBoolean(LOCATION, isDenied);
                break;
            }
            case 430: {
                sharedPref.putBoolean(MICROPHONE, isDenied);
                break;
            }
            case 442: {
                sharedPref.putBoolean(PHONE, isDenied);
                break;
            }
            case 443: {
                sharedPref.putBoolean(SENSORS, isDenied);
                break;
            }
            case 431: {
                sharedPref.putBoolean(SMS, isDenied);
                break;
            }
            case 444: {
                sharedPref.putBoolean(STORAGE, isDenied);
                break;
            }
        }
        boolean result = sharedPref.commit();
        Log.d((String)"SharedPref", (String)("putInSharedPref:Commit " + result));
    }

    public static boolean isDeniedOnce(Context context, int permissionCode) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_FILE_NAME, 0);
        switch (permissionCode) {
            case 427: {
                return sharedPreferences.getBoolean(CONTACTS, false);
            }
            case 429: {
                return sharedPreferences.getBoolean(CALENDAR, false);
            }
            case 426: {
                return sharedPreferences.getBoolean(CAMERA, false);
            }
            case 428: {
                return sharedPreferences.getBoolean(LOCATION, false);
            }
            case 430: {
                return sharedPreferences.getBoolean(MICROPHONE, false);
            }
            case 442: {
                return sharedPreferences.getBoolean(PHONE, false);
            }
            case 443: {
                return sharedPreferences.getBoolean(SENSORS, false);
            }
            case 431: {
                return sharedPreferences.getBoolean(SMS, false);
            }
            case 444: {
                return sharedPreferences.getBoolean(STORAGE, false);
            }
        }
        return false;
    }
}

