/*
 * Decompiled with CFR 0.152.
 */
package com.github.karthyks.runtimepermissions;

import android.content.Context;
import android.support.v4.app.Fragment;
import android.support.v7.app.AppCompatActivity;
import com.github.karthyks.runtimepermissions.PermissionActivity;

public class Permission {
    public static final int REQUEST_CAMERA = 200;
    public static final int REQUEST_CONTACTS = 201;
    public static final int REQUEST_LOCATION = 202;
    public static final int REQUEST_CALENDAR = 203;
    public static final int REQUEST_MICROPHONE = 204;
    public static final int REQUEST_SMS = 205;
    public static final int REQUEST_PHONE = 206;
    public static final int REQUEST_SENSORS = 207;
    public static final int REQUEST_STORAGE = 208;
    private static String[] PERMISSIONS_CONTACT = new String[]{"android.permission.READ_CONTACTS", "android.permission.WRITE_CONTACTS", "android.permission.GET_ACCOUNTS"};
    private static String[] PERMISSIONS_LOCATION = new String[]{"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"};
    private static String[] PERMISSIONS_CALENDAR = new String[]{"android.permission.READ_CALENDAR", "android.permission.WRITE_CALENDAR"};
    private static String[] PERMISSIONS_SMS = new String[]{"android.permission.READ_SMS", "android.permission.SEND_SMS", "android.permission.RECEIVE_SMS"};
    private static String[] PERMISSIONS_PHONE = new String[]{"android.permission.READ_PHONE_STATE", "android.permission.CALL_PHONE", "android.permission.READ_CALL_LOG", "android.permission.WRITE_CALL_LOG", "android.permission.PROCESS_OUTGOING_CALLS", "android.permission.USE_SIP"};
    private static String[] PERMISSIONS_STORAGE = new String[]{"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"};
    private int permissionCode;
    private String[] permissions;
    private AppCompatActivity requestedActivity;
    private String rationale;
    private Fragment requestedFragment;

    private Permission(PermissionBuilder builder) {
        this.permissionCode = builder.permissionCode;
        this.permissions = builder.permissions;
        if (builder.activity != null) {
            this.requestedActivity = builder.activity;
        }
        if (builder.fragment != null) {
            this.requestedFragment = builder.fragment;
        }
        this.rationale = builder.rationale;
    }

    public void requestPermission(int requestCode) {
        if (this.requestedActivity != null) {
            this.requestedActivity.startActivityForResult(PermissionActivity.getInstance((Context)this.requestedActivity, this.permissionCode, this.permissions, this.rationale), requestCode);
        } else if (this.requestedFragment != null) {
            this.requestedFragment.startActivityForResult(PermissionActivity.getInstance(this.requestedFragment.getContext(), this.permissionCode, this.permissions, this.rationale), requestCode);
        } else {
            throw new RuntimeException("Null Activity or Fragment");
        }
    }

    public static class PermissionBuilder {
        private int permissionCode;
        private String[] permissions;
        private AppCompatActivity activity;
        private Fragment fragment;
        private String rationale;

        public PermissionBuilder(int permissionCode) {
            this.permissionCode = permissionCode;
            this.permissions = this.getPermissions(permissionCode);
        }

        public PermissionBuilder usingActivity(AppCompatActivity activity) {
            this.activity = activity;
            return this;
        }

        public PermissionBuilder usingFragment(Fragment fragment) {
            this.fragment = fragment;
            return this;
        }

        public PermissionBuilder withRationale(String rationaleDialog) {
            this.rationale = rationaleDialog;
            return this;
        }

        public Permission build() {
            return new Permission(this);
        }

        private String[] getPermissions(int requestCode) {
            switch (requestCode) {
                case 200: {
                    return new String[]{"android.permission.CAMERA"};
                }
                case 201: {
                    return PERMISSIONS_CONTACT;
                }
                case 202: {
                    return PERMISSIONS_LOCATION;
                }
                case 203: {
                    return PERMISSIONS_CALENDAR;
                }
                case 204: {
                    return new String[]{"android.permission.RECORD_AUDIO"};
                }
                case 205: {
                    return PERMISSIONS_SMS;
                }
                case 206: {
                    return PERMISSIONS_PHONE;
                }
                case 208: {
                    return PERMISSIONS_STORAGE;
                }
                case 207: {
                    return new String[]{"android.permission.BODY_SENSORS", "android.permission.USE_FINGERPRINT"};
                }
            }
            return new String[0];
        }
    }
}

