/*
 * Decompiled with CFR 0.152.
 */
package com.github.karthyks.runtimepermissions;

import android.content.Context;
import android.support.v7.app.AppCompatActivity;
import com.github.karthyks.runtimepermissions.PermissionActivity;

public class Permission {
    public static final int REQUEST_CAMERA = 200;
    public static final int REQUEST_CONTACTS = 201;
    public static final int REQUEST_LOCATION = 202;
    public static final int REQUEST_CALENDAR = 203;
    public static final int REQUEST_MICROPHONE = 204;
    private static String[] PERMISSIONS_CONTACT = new String[]{"android.permission.READ_CONTACTS", "android.permission.WRITE_CONTACTS"};
    private static String[] PERMISSIONS_LOCATION = new String[]{"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"};
    private static String[] PERMISSIONS_CALENDAR = new String[]{"android.permission.READ_CALENDAR", "android.permission.WRITE_CALENDAR"};
    private int permissionCode;
    private String[] permissions;
    private AppCompatActivity requestedActivity;
    private String rationale;

    private Permission(PermissionBuilder builder) {
        this.permissionCode = builder.permissionCode;
        this.permissions = builder.permissions;
        this.requestedActivity = builder.activity;
        this.rationale = builder.rationale;
    }

    public void requestPermission(int requestCode) {
        this.requestedActivity.startActivityForResult(PermissionActivity.getInstance((Context)this.requestedActivity, this.permissionCode, this.permissions, this.rationale), requestCode);
    }

    public static class PermissionBuilder {
        private int permissionCode;
        private String[] permissions;
        private AppCompatActivity activity;
        private String rationale;

        public PermissionBuilder(int permissionCode) {
            this.permissionCode = permissionCode;
            this.permissions = this.getPermissions(permissionCode);
        }

        public PermissionBuilder using(AppCompatActivity activity) {
            this.activity = activity;
            return this;
        }

        public PermissionBuilder withRationale(String rationaleDialog) {
            this.rationale = rationaleDialog;
            return this;
        }

        public Permission build() {
            return new Permission(this);
        }

        private String[] getPermissions(int requestCode) {
            switch (requestCode) {
                case 200: {
                    return new String[]{"android.permission.CAMERA"};
                }
                case 201: {
                    return PERMISSIONS_CONTACT;
                }
                case 202: {
                    return PERMISSIONS_LOCATION;
                }
                case 203: {
                    return PERMISSIONS_CALENDAR;
                }
                case 204: {
                    return new String[]{"android.permission.RECORD_AUDIO"};
                }
            }
            return new String[0];
        }
    }
}

