/*
 * Decompiled with CFR 0.152.
 */
package com.github.karthyks.runtimepermissions.prefs;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;

public class SharedPrefUtil {
    public static final String PREF_FILE_NAME = "runtime_permission_checker";
    public static final String LOCATION = "location";
    public static final String CONTACTS = "contacts";
    public static final String CALENDAR = "calendar";
    public static final String CAMERA = "camera";
    public static final String MICROPHONE = "microphone";

    public static void putInSharedPref(Context context, int permissionCode, boolean isDenied) {
        SharedPreferences.Editor sharedPref = context.getSharedPreferences(PREF_FILE_NAME, 0).edit();
        switch (permissionCode) {
            case 4901: {
                sharedPref.putBoolean(CONTACTS, isDenied);
                break;
            }
            case 4903: {
                sharedPref.putBoolean(CALENDAR, isDenied);
                break;
            }
            case 4900: {
                sharedPref.putBoolean(CAMERA, isDenied);
                break;
            }
            case 4902: {
                sharedPref.putBoolean(LOCATION, isDenied);
                break;
            }
            case 4904: {
                sharedPref.putBoolean(MICROPHONE, isDenied);
                break;
            }
        }
        boolean result = sharedPref.commit();
        Log.d((String)"SharedPref", (String)("putInSharedPref:Commit " + result));
    }

    public static boolean isDeniedOnce(Context context, int permissionCode) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_FILE_NAME, 0);
        switch (permissionCode) {
            case 4901: {
                return sharedPreferences.getBoolean(CONTACTS, false);
            }
            case 4903: {
                return sharedPreferences.getBoolean(CALENDAR, false);
            }
            case 4900: {
                return sharedPreferences.getBoolean(CAMERA, false);
            }
            case 4902: {
                return sharedPreferences.getBoolean(LOCATION, false);
            }
            case 4904: {
                return sharedPreferences.getBoolean(MICROPHONE, false);
            }
        }
        return false;
    }
}

