/*
 * Decompiled with CFR 0.152.
 */
package com.kapil.circularlayoutmanager;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.PointF;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;
import androidx.recyclerview.widget.LinearSmoothScroller;
import androidx.recyclerview.widget.RecyclerView;
import com.kapil.circularlayoutmanager.R;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\b\u0016\u0018\u0000 ^2\u00020\u00012\u00020\u0002:\u0001^B/\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nB\u0017\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0002\u0010\u000eB\u001f\b\u0016\u0012\u0006\u0010\u000f\u001a\u00020\f\u0012\u0006\u0010\u0010\u001a\u00020\f\u0012\u0006\u0010\u0011\u001a\u00020\f\u00a2\u0006\u0002\u0010\u0012J\u0014\u0010)\u001a\u00020*2\n\u0010+\u001a\u00060\u001cR\u00020\u001dH\u0002J\u0010\u0010,\u001a\u00020\u00162\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u0010/\u001a\u00020\u00162\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u00100\u001a\u00020\b2\u0006\u00101\u001a\u00020\bH\u0002J\u0014\u00102\u001a\u00020*2\n\u0010+\u001a\u00060\u001cR\u00020\u001dH\u0002J(\u00103\u001a\u00020\b2\u0006\u00104\u001a\u00020\b2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\b2\u0006\u00108\u001a\u00020\bH\u0002J\b\u00109\u001a\u00020\u0016H\u0016J\b\u0010:\u001a\u00020*H\u0002J\u0010\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\bH\u0016J\u0010\u0010>\u001a\u00020\b2\u0006\u0010?\u001a\u00020@H\u0016J\u0010\u0010A\u001a\u00020\b2\u0006\u0010?\u001a\u00020@H\u0016J\u0010\u0010B\u001a\u00020\b2\u0006\u0010?\u001a\u00020@H\u0016J\u0010\u0010C\u001a\u00020\u00162\u0006\u0010D\u001a\u00020\bH\u0002J\u0010\u0010E\u001a\u00020\u00162\u0006\u0010D\u001a\u00020\bH\u0002J\u0010\u0010F\u001a\u00020\b2\u0006\u0010G\u001a\u00020\bH\u0002J\u0014\u0010H\u001a\u00020*2\n\u0010+\u001a\u00060\u001cR\u00020\u001dH\u0002J\b\u0010I\u001a\u00020JH\u0016J$\u0010K\u001a\u00020*2\f\u0010L\u001a\b\u0012\u0002\b\u0003\u0018\u00010M2\f\u0010N\u001a\b\u0012\u0002\b\u0003\u0018\u00010MH\u0016J\u001c\u0010O\u001a\u00020*2\n\u0010+\u001a\u00060\u001cR\u00020\u001d2\u0006\u0010?\u001a\u00020@H\u0016J\u0012\u0010P\u001a\u00020*2\b\u0010?\u001a\u0004\u0018\u00010@H\u0016J\u0012\u0010Q\u001a\u00020*2\b\u0010?\u001a\u0004\u0018\u00010RH\u0016J\b\u0010S\u001a\u00020RH\u0016J\u0010\u0010T\u001a\u00020*2\u0006\u0010?\u001a\u00020\bH\u0016J\u0010\u0010U\u001a\u00020*2\u0006\u00105\u001a\u000206H\u0002J\u0010\u0010V\u001a\u00020*2\u0006\u00104\u001a\u00020\bH\u0016J$\u0010W\u001a\u00020\b2\u0006\u0010G\u001a\u00020\b2\n\u0010+\u001a\u00060\u001cR\u00020\u001d2\u0006\u0010?\u001a\u00020@H\u0016J \u0010X\u001a\u00020*2\u0006\u0010Y\u001a\u00020\u001d2\u0006\u0010?\u001a\u00020@2\u0006\u00104\u001a\u00020\bH\u0016J\u0006\u0010Z\u001a\u00020*J(\u0010[\u001a\u00020*2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010=\u001a\u00020\b2\u0006\u0010\\\u001a\u00020\f2\u0006\u0010]\u001a\u00020\u0016H\u0002R\u000e\u0010\u0013\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001b\u001a\u00060\u001cR\u00020\u001dX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u0017\"\u0004\b%\u0010\u0019R\u001a\u0010&\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u0017\"\u0004\b(\u0010\u0019R\u000e\u0010\u0011\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006_"}, d2={"Lcom/kapil/circularlayoutmanager/CircularLayoutManager;", "Landroidx/recyclerview/widget/RecyclerView$LayoutManager;", "Landroidx/recyclerview/widget/RecyclerView$SmoothScroller$ScrollVectorProvider;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "defStyleRes", "(Landroid/content/Context;Landroid/util/AttributeSet;II)V", "radius", "", "centerX", "(FF)V", "xRadius", "yRadius", "xCenter", "(FFF)V", "fillStartPosition", "firstChildTopOffset", "isAutoStabilizationEnabled", "", "()Z", "setAutoStabilizationEnabled", "(Z)V", "isFirstChildParametersProgrammaticallyUpdated", "mRecycler", "Landroidx/recyclerview/widget/RecyclerView$Recycler;", "Landroidx/recyclerview/widget/RecyclerView;", "scalingFactor", "getScalingFactor", "()F", "setScalingFactor", "(F)V", "shouldCenterIfProgrammaticallyScrolled", "getShouldCenterIfProgrammaticallyScrolled", "setShouldCenterIfProgrammaticallyScrolled", "shouldIgnoreHeaderAndFooterMargins", "getShouldIgnoreHeaderAndFooterMargins", "setShouldIgnoreHeaderAndFooterMargins", "adjustGapsIfProgrammaticallyScrolled", "", "recycler", "areAttrsForCircleAvailable", "a", "Landroid/content/res/TypedArray;", "areAttrsForEllipseAvailable", "calculateEllipseXFromY", "y", "calculateFirstChildPlacement", "calculateLeftOffset", "position", "child", "Landroid/view/View;", "childHeight", "tmpOffset", "canScrollVertically", "clearScrollState", "computeScrollVectorForPosition", "Landroid/graphics/PointF;", "targetPosition", "computeVerticalScrollExtent", "state", "Landroidx/recyclerview/widget/RecyclerView$State;", "computeVerticalScrollOffset", "computeVerticalScrollRange", "couldChildBeBroughtDownToCenter", "nearestChildIndex", "couldChildBeBroughtUpToCenter", "determineActualScroll", "dy", "fill", "generateDefaultLayoutParams", "Landroidx/recyclerview/widget/RecyclerView$LayoutParams;", "onAdapterChanged", "oldAdapter", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "newAdapter", "onLayoutChildren", "onLayoutCompleted", "onRestoreInstanceState", "Landroid/os/Parcelable;", "onSaveInstanceState", "onScrollStateChanged", "scaleChild", "scrollToPosition", "scrollVerticallyBy", "smoothScrollToPosition", "recyclerView", "stabilize", "startSmoothScroll", "millisPerInch", "shouldCenter", "Companion", "circular-layout-manager_release"})
public class CircularLayoutManager
extends RecyclerView.LayoutManager
implements RecyclerView.SmoothScroller.ScrollVectorProvider {
    private final float xRadius;
    private final float yRadius;
    private final float xCenter;
    private int fillStartPosition;
    private int firstChildTopOffset;
    private boolean isFirstChildParametersProgrammaticallyUpdated;
    private RecyclerView.Recycler mRecycler;
    private boolean shouldIgnoreHeaderAndFooterMargins;
    private float scalingFactor;
    private boolean shouldCenterIfProgrammaticallyScrolled;
    private boolean isAutoStabilizationEnabled;
    private static final String TAG;
    private static final String FILL_START_POSITION = "FILL_START_POSITION";
    private static final String FIRST_CHILD_TOP_OFFSET = "FIRST_CHILD_TOP_OFFSET";
    private static final float MILLIS_PER_INCH_FAST = 25.0f;
    private static final float MILLIS_PER_INCH_SLOW = 200.0f;
    public static final Companion Companion;

    public final boolean getShouldIgnoreHeaderAndFooterMargins() {
        return this.shouldIgnoreHeaderAndFooterMargins;
    }

    public final void setShouldIgnoreHeaderAndFooterMargins(boolean bl) {
        this.shouldIgnoreHeaderAndFooterMargins = bl;
    }

    public final float getScalingFactor() {
        return this.scalingFactor;
    }

    public final void setScalingFactor(float f) {
        this.scalingFactor = f;
    }

    public final boolean getShouldCenterIfProgrammaticallyScrolled() {
        return this.shouldCenterIfProgrammaticallyScrolled;
    }

    public final void setShouldCenterIfProgrammaticallyScrolled(boolean bl) {
        this.shouldCenterIfProgrammaticallyScrolled = bl;
    }

    public final boolean isAutoStabilizationEnabled() {
        return this.isAutoStabilizationEnabled;
    }

    public final void setAutoStabilizationEnabled(boolean bl) {
        this.isAutoStabilizationEnabled = bl;
    }

    @NotNull
    public RecyclerView.LayoutParams generateDefaultLayoutParams() {
        return new RecyclerView.LayoutParams(-2, -2);
    }

    public void onLayoutChildren(@NotNull RecyclerView.Recycler recycler, @NotNull RecyclerView.State state) {
        Intrinsics.checkParameterIsNotNull((Object)recycler, (String)"recycler");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        this.adjustGapsIfProgrammaticallyScrolled(recycler);
        this.fill(recycler);
    }

    public void onLayoutCompleted(@Nullable RecyclerView.State state) {
        super.onLayoutCompleted(state);
        if (this.isAutoStabilizationEnabled) {
            this.stabilize();
        }
    }

    public boolean canScrollVertically() {
        return true;
    }

    public int scrollVerticallyBy(int dy, @NotNull RecyclerView.Recycler recycler, @NotNull RecyclerView.State state) {
        Intrinsics.checkParameterIsNotNull((Object)recycler, (String)"recycler");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        if (this.getChildCount() == 0) {
            return 0;
        }
        int scrolled = this.determineActualScroll(dy);
        this.offsetChildrenVertical(-scrolled);
        this.calculateFirstChildPlacement(recycler);
        this.fill(recycler);
        return scrolled;
    }

    public void scrollToPosition(int position) {
        int n = position;
        if (0 <= n && this.getItemCount() > n) {
            this.fillStartPosition = position;
            this.firstChildTopOffset = 0;
            this.isFirstChildParametersProgrammaticallyUpdated = true;
            this.requestLayout();
        } else {
            Log.e((String)TAG, (String)("scrollToPosition: Index: " + position + ", Size: " + this.getItemCount()));
        }
    }

    public void smoothScrollToPosition(@NotNull RecyclerView recyclerView, @NotNull RecyclerView.State state, int position) {
        Intrinsics.checkParameterIsNotNull((Object)recyclerView, (String)"recyclerView");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        int n = position;
        if (0 <= n && this.getItemCount() > n) {
            Context context = recyclerView.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"recyclerView.context");
            this.startSmoothScroll(context, position, 25.0f, this.shouldCenterIfProgrammaticallyScrolled);
        } else {
            Log.e((String)TAG, (String)("smoothScrollToPosition: Index: " + position + ", Size: " + this.getItemCount()));
        }
    }

    public void onScrollStateChanged(int state) {
        super.onScrollStateChanged(state);
        if (this.isAutoStabilizationEnabled && state == 0) {
            this.stabilize();
        }
    }

    @NotNull
    public PointF computeScrollVectorForPosition(int targetPosition) {
        return new PointF(0.0f, (float)(targetPosition - this.fillStartPosition));
    }

    public int computeVerticalScrollOffset(@NotNull RecyclerView.State state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        View view = this.getChildAt(0);
        if (view == null) {
            Intrinsics.throwNpe();
        }
        return this.getPosition(view);
    }

    public int computeVerticalScrollExtent(@NotNull RecyclerView.State state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        View view = this.getChildAt(this.getChildCount() - 1);
        if (view == null) {
            Intrinsics.throwNpe();
        }
        int n = this.getPosition(view);
        View view2 = this.getChildAt(0);
        if (view2 == null) {
            Intrinsics.throwNpe();
        }
        return n - this.getPosition(view2) + 1;
    }

    public int computeVerticalScrollRange(@NotNull RecyclerView.State state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        return this.getItemCount();
    }

    public void onAdapterChanged(@Nullable RecyclerView.Adapter<?> oldAdapter, @Nullable RecyclerView.Adapter<?> newAdapter) {
        super.onAdapterChanged(oldAdapter, newAdapter);
        this.removeAllViews();
        this.clearScrollState();
    }

    @NotNull
    public Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        boolean bl = false;
        boolean bl2 = false;
        Bundle $this$apply = bundle;
        boolean bl3 = false;
        $this$apply.putInt(FILL_START_POSITION, this.fillStartPosition);
        $this$apply.putInt(FIRST_CHILD_TOP_OFFSET, this.firstChildTopOffset);
        return (Parcelable)bundle;
    }

    public void onRestoreInstanceState(@Nullable Parcelable state) {
        block1: {
            Parcelable parcelable = state;
            if (!(parcelable instanceof Bundle)) {
                parcelable = null;
            }
            Bundle bundle = (Bundle)parcelable;
            if (bundle == null) break block1;
            Bundle bundle2 = bundle;
            boolean bl = false;
            boolean bl2 = false;
            Bundle it = bundle2;
            boolean bl3 = false;
            this.fillStartPosition = it.getInt(FILL_START_POSITION);
            this.firstChildTopOffset = it.getInt(FIRST_CHILD_TOP_OFFSET);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void fill(RecyclerView.Recycler recycler) {
        if (this.getItemCount() == 0) {
            this.removeAndRecycleAllViews(recycler);
            return;
        }
        this.mRecycler = recycler;
        int tmpOffset = this.firstChildTopOffset;
        this.detachAndScrapAttachedViews(recycler);
        int n = this.fillStartPosition;
        int n2 = this.getItemCount();
        while (n < n2) {
            View child;
            void position;
            Intrinsics.checkExpressionValueIsNotNull((Object)recycler.getViewForPosition((int)position), (String)"recycler.getViewForPosition(position)");
            this.addView(child);
            this.measureChildWithMargins(child, 0, 0);
            int childWidth = this.getDecoratedMeasuredWidth(child);
            int childHeight = this.getDecoratedMeasuredHeight(child);
            int left = this.calculateLeftOffset((int)position, child, childHeight, tmpOffset);
            int top = tmpOffset;
            this.layoutDecoratedWithMargins(child, left, top, left + childWidth, top + childHeight);
            this.scaleChild(child);
            if ((tmpOffset += childHeight) > this.getHeight()) break;
            ++position;
        }
        List list = recycler.getScrapList();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"recycler.scrapList");
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)list);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RecyclerView.ViewHolder it = (RecyclerView.ViewHolder)element$iv;
            boolean bl = false;
            recycler.recycleView(it.itemView);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void calculateFirstChildPlacement(RecyclerView.Recycler recycler) {
        int n = 0;
        int n2 = this.getChildCount();
        while (n < n2) {
            View tmpChild;
            void i;
            if (this.getChildAt((int)i) == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)tmpChild, (String)"getChildAt(i)!!");
            if (this.getDecoratedBottom(tmpChild) > 0) {
                this.firstChildTopOffset = this.getDecoratedTop(tmpChild);
                this.fillStartPosition = this.getPosition(tmpChild);
                break;
            }
            ++i;
        }
        while (this.firstChildTopOffset > 0) {
            View tmpChild;
            --this.fillStartPosition;
            if (this.fillStartPosition < 0) {
                this.clearScrollState();
                break;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)recycler.getViewForPosition(this.fillStartPosition), (String)"recycler.getViewForPosition(fillStartPosition)");
            this.measureChildWithMargins(tmpChild, 0, 0);
            this.firstChildTopOffset -= this.getDecoratedMeasuredHeight(tmpChild);
        }
    }

    private final void scaleChild(View child) {
        int y = (child.getTop() + child.getBottom()) / 2;
        float f = (float)this.getHeight() / 2.0f - (float)y;
        float f2 = this.scalingFactor;
        float f3 = 1.0f;
        boolean bl = false;
        float f4 = Math.abs(f);
        float scale = f3 - f2 * (f4 / (float)(this.getHeight() - child.getHeight()));
        child.setPivotX(0.0f);
        child.setPivotY((float)child.getHeight() / 2.0f);
        child.setScaleX(scale);
        child.setScaleY(scale);
    }

    private final int calculateLeftOffset(int position, View child, int childHeight, int tmpOffset) {
        int n;
        return this.shouldIgnoreHeaderAndFooterMargins ? ((n = position) == 0 ? this.calculateEllipseXFromY(tmpOffset + this.getTopDecorationHeight(child) + (childHeight - this.getTopDecorationHeight(child)) / 2) : (n == this.getItemCount() - 1 ? this.calculateEllipseXFromY(tmpOffset + (childHeight - this.getBottomDecorationHeight(child)) / 2) : this.calculateEllipseXFromY(tmpOffset + childHeight / 2))) : this.calculateEllipseXFromY(tmpOffset + childHeight / 2);
    }

    private final int calculateEllipseXFromY(int y) {
        int n;
        float yCenter = (float)this.getHeight() / 2.0f;
        double amount = (double)(1.0f - ((float)y - yCenter) * ((float)y - yCenter) / (this.yRadius * this.yRadius)) * (double)(this.xRadius * this.xRadius);
        if (amount >= 0.0) {
            boolean bl = false;
            n = (int)(Math.sqrt(amount) + (double)this.xCenter);
        } else {
            double d = -amount;
            boolean bl = false;
            n = (int)(-Math.sqrt(d) + (double)this.xCenter);
        }
        return n;
    }

    private final int determineActualScroll(int dy) {
        View view = this.getChildAt(0);
        if (view == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"getChildAt(0)!!");
        View firstChild = view;
        View view2 = this.getChildAt(this.getChildCount() - 1);
        if (view2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"getChildAt(childCount - 1)!!");
        View lastChild = view2;
        return dy < 0 && this.getPosition(firstChild) == 0 && this.getDecoratedTop(firstChild) - dy > 0 ? this.getDecoratedTop(firstChild) : (dy > 0 && this.getPosition(lastChild) == this.getItemCount() - 1 && this.getDecoratedBottom(lastChild) - dy < this.getHeight() ? this.getDecoratedBottom(lastChild) - this.getHeight() : dy);
    }

    /*
     * WARNING - void declaration
     */
    private final void adjustGapsIfProgrammaticallyScrolled(RecyclerView.Recycler recycler) {
        if (this.isFirstChildParametersProgrammaticallyUpdated) {
            int n;
            int topGap;
            if (this.shouldCenterIfProgrammaticallyScrolled) {
                View view = recycler.getViewForPosition(this.fillStartPosition);
                Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"recycler.getViewForPosition(fillStartPosition)");
                View centerChild = view;
                this.measureChildWithMargins(centerChild, 0, 0);
                topGap = this.getHeight() / 2 - this.getDecoratedMeasuredHeight(centerChild) / 2;
                n = this.fillStartPosition - 1;
                boolean bl = false;
                while (n >= 0) {
                    View tmpChild;
                    void position;
                    Intrinsics.checkExpressionValueIsNotNull((Object)recycler.getViewForPosition((int)position), (String)"recycler.getViewForPosition(position)");
                    this.measureChildWithMargins(tmpChild, 0, 0);
                    if ((topGap -= this.getDecoratedMeasuredHeight(tmpChild)) <= 0) {
                        this.fillStartPosition = position;
                        this.firstChildTopOffset = topGap;
                        break;
                    }
                    --position;
                }
                if (topGap > 0) {
                    this.clearScrollState();
                }
            }
            int bottomGap = this.getHeight();
            topGap = this.getItemCount() - 1;
            n = 0;
            while (topGap >= 0) {
                View tmpChild;
                void position;
                Intrinsics.checkExpressionValueIsNotNull((Object)recycler.getViewForPosition((int)position), (String)"recycler.getViewForPosition(position)");
                this.measureChildWithMargins(tmpChild, 0, 0);
                if ((bottomGap -= this.getDecoratedMeasuredHeight(tmpChild)) <= 0) {
                    if (position >= this.fillStartPosition && (position != this.fillStartPosition || bottomGap <= this.firstChildTopOffset)) break;
                    this.fillStartPosition = position;
                    this.firstChildTopOffset = bottomGap;
                    break;
                }
                --position;
            }
            if (bottomGap > 0) {
                this.clearScrollState();
            }
            this.isFirstChildParametersProgrammaticallyUpdated = false;
        }
    }

    private final void startSmoothScroll(Context context, int targetPosition, float millisPerInch, boolean shouldCenter) {
        LinearSmoothScroller linearSmoothScroller = new LinearSmoothScroller(shouldCenter, millisPerInch, context, context){
            final /* synthetic */ boolean $shouldCenter;
            final /* synthetic */ float $millisPerInch;
            final /* synthetic */ Context $context;

            public int calculateDtToFit(int viewStart, int viewEnd, int boxStart, int boxEnd, int snapPreference) {
                return this.$shouldCenter ? (boxStart + boxEnd) / 2 - (viewStart + viewEnd) / 2 : super.calculateDtToFit(viewStart, viewEnd, boxStart, boxEnd, snapPreference);
            }

            protected float calculateSpeedPerPixel(@NotNull DisplayMetrics displayMetrics) {
                Intrinsics.checkParameterIsNotNull((Object)displayMetrics, (String)"displayMetrics");
                return this.$millisPerInch / (float)displayMetrics.densityDpi;
            }
            {
                this.$shouldCenter = $captured_local_variable$0;
                this.$millisPerInch = $captured_local_variable$1;
                this.$context = $captured_local_variable$2;
                super($super_call_param$3);
            }
        };
        boolean bl = false;
        boolean bl2 = false;
        LinearSmoothScroller $this$apply = linearSmoothScroller;
        boolean bl3 = false;
        $this$apply.setTargetPosition(targetPosition);
        this.startSmoothScroll((RecyclerView.SmoothScroller)$this$apply);
    }

    private final void clearScrollState() {
        this.fillStartPosition = 0;
        this.firstChildTopOffset = 0;
    }

    private final boolean areAttrsForCircleAvailable(TypedArray a) {
        return a.hasValue(R.styleable.RecyclerView_radius) && a.hasValue(R.styleable.RecyclerView_xCenter);
    }

    private final boolean areAttrsForEllipseAvailable(TypedArray a) {
        return a.hasValue(R.styleable.RecyclerView_xRadius) && a.hasValue(R.styleable.RecyclerView_yRadius) && a.hasValue(R.styleable.RecyclerView_xCenter);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean couldChildBeBroughtDownToCenter(int nearestChildIndex) {
        View view = this.getChildAt(nearestChildIndex);
        if (view == null) {
            Intrinsics.throwNpe();
        }
        int nearestChildPosition = this.getPosition(view);
        int topGap = this.getHeight() / 2;
        int n = 0;
        int n2 = nearestChildPosition;
        while (n < n2) {
            View child;
            void i;
            RecyclerView.Recycler recycler = this.mRecycler;
            if (recycler == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mRecycler");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)recycler.getViewForPosition((int)i), (String)"mRecycler.getViewForPosition(i)");
            this.measureChildWithMargins(child, 0, 0);
            if ((topGap -= this.getDecoratedMeasuredHeight(child)) <= 0) {
                return true;
            }
            ++i;
        }
        RecyclerView.Recycler recycler = this.mRecycler;
        if (recycler == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mRecycler");
        }
        View view2 = recycler.getViewForPosition(nearestChildPosition);
        Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"mRecycler.getViewForPosition(nearestChildPosition)");
        View nearestChild = view2;
        this.measureChildWithMargins(nearestChild, 0, 0);
        return (topGap -= this.getDecoratedMeasuredHeight(nearestChild) / 2) <= 0;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean couldChildBeBroughtUpToCenter(int nearestChildIndex) {
        int n;
        View view = this.getChildAt(nearestChildIndex);
        if (view == null) {
            Intrinsics.throwNpe();
        }
        int nearestChildPosition = this.getPosition(view);
        int bottomGap = this.getHeight() / 2;
        int n2 = this.getItemCount() - 1;
        if (n2 >= (n = nearestChildPosition + 1)) {
            while (true) {
                View child;
                void i;
                RecyclerView.Recycler recycler = this.mRecycler;
                if (recycler == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mRecycler");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)recycler.getViewForPosition((int)i), (String)"mRecycler.getViewForPosition(i)");
                this.measureChildWithMargins(child, 0, 0);
                if ((bottomGap -= this.getDecoratedMeasuredHeight(child)) <= 0) {
                    return true;
                }
                if (i == n) break;
                --i;
            }
        }
        RecyclerView.Recycler recycler = this.mRecycler;
        if (recycler == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mRecycler");
        }
        View view2 = recycler.getViewForPosition(nearestChildPosition);
        Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"mRecycler.getViewForPosition(nearestChildPosition)");
        View nearestChild = view2;
        this.measureChildWithMargins(nearestChild, 0, 0);
        return (bottomGap -= this.getDecoratedMeasuredHeight(nearestChild) / 2) <= 0;
    }

    /*
     * WARNING - void declaration
     */
    public final void stabilize() {
        if (this.getChildCount() == 0 || this.isSmoothScrolling()) {
            return;
        }
        int minDistance = Integer.MAX_VALUE;
        int nearestChildIndex = 0;
        int yCenter = this.getHeight() / 2;
        int n = 0;
        int n2 = this.getChildCount();
        while (n < n2) {
            View child;
            void i;
            if (this.getChildAt((int)i) == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)child, (String)"getChildAt(i)!!");
            int y = (this.getDecoratedTop(child) + this.getDecoratedBottom(child)) / 2;
            int n3 = y - yCenter;
            boolean bl = false;
            int n4 = Math.abs(n3);
            n3 = 0;
            int n5 = Math.abs(minDistance);
            if (n4 >= n5) break;
            nearestChildIndex = i++;
            minDistance = y - yCenter;
        }
        boolean isStabilizationPossible = false;
        if (minDistance < 0) {
            if (this.couldChildBeBroughtDownToCenter(nearestChildIndex)) {
                isStabilizationPossible = true;
            } else if (nearestChildIndex + 1 < this.getChildCount() && this.couldChildBeBroughtUpToCenter(nearestChildIndex + 1)) {
                ++nearestChildIndex;
                isStabilizationPossible = true;
            }
        } else if (minDistance > 0) {
            if (this.couldChildBeBroughtUpToCenter(nearestChildIndex)) {
                isStabilizationPossible = true;
            } else if (nearestChildIndex - 1 >= 0 && this.couldChildBeBroughtDownToCenter(nearestChildIndex - 1)) {
                --nearestChildIndex;
                isStabilizationPossible = true;
            }
        }
        if (isStabilizationPossible) {
            View view = this.getChildAt(nearestChildIndex);
            if (view == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"getChildAt(nearestChildIndex)!!");
            Context context = view.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"getChildAt(nearestChildIndex)!!.context");
            View view2 = this.getChildAt(nearestChildIndex);
            if (view2 == null) {
                Intrinsics.throwNpe();
            }
            this.startSmoothScroll(context, this.getPosition(view2), 200.0f, true);
        }
    }

    public CircularLayoutManager(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.shouldCenterIfProgrammaticallyScrolled = true;
        this.isAutoStabilizationEnabled = true;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.RecyclerView, defStyleAttr, defStyleRes);
        TypedArray typedArray = a;
        Intrinsics.checkExpressionValueIsNotNull((Object)typedArray, (String)"a");
        if (this.areAttrsForCircleAvailable(typedArray)) {
            this.xRadius = a.getDimension(R.styleable.RecyclerView_radius, 0.0f);
            this.yRadius = a.getDimension(R.styleable.RecyclerView_radius, 0.0f);
            this.xCenter = a.getDimension(R.styleable.RecyclerView_xCenter, 0.0f);
        } else if (this.areAttrsForEllipseAvailable(a)) {
            this.xRadius = a.getDimension(R.styleable.RecyclerView_xRadius, 0.0f);
            this.yRadius = a.getDimension(R.styleable.RecyclerView_yRadius, 0.0f);
            this.xCenter = a.getDimension(R.styleable.RecyclerView_xCenter, 0.0f);
        } else {
            throw (Throwable)new InstantiationException("All the necessary attributes need to be supplied. For circle: radius and xCenter OR For ellipse: xRadius, yRadius and xCenter");
        }
        this.scalingFactor = a.getFloat(R.styleable.RecyclerView_scalingFactor, 0.0f);
        this.shouldIgnoreHeaderAndFooterMargins = a.getBoolean(R.styleable.RecyclerView_shouldIgnoreHeaderAndFooterMargins, false);
        this.shouldCenterIfProgrammaticallyScrolled = a.getBoolean(R.styleable.RecyclerView_shouldCenterIfProgrammaticallyScrolled, true);
        this.isAutoStabilizationEnabled = a.getBoolean(R.styleable.RecyclerView_isAutoStabilizationEnabled, true);
        a.recycle();
    }

    public /* synthetic */ CircularLayoutManager(Context context, AttributeSet attributeSet, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            attributeSet = null;
        }
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = 0;
        }
        this(context, attributeSet, n, n2);
    }

    public CircularLayoutManager(float radius, float centerX) {
        this(radius, radius, centerX);
    }

    public CircularLayoutManager(float xRadius, float yRadius, float xCenter) {
        this.shouldCenterIfProgrammaticallyScrolled = true;
        this.isAutoStabilizationEnabled = true;
        this.xRadius = xRadius;
        this.yRadius = yRadius;
        this.xCenter = xCenter;
    }

    static {
        Companion = new Companion(null);
        TAG = Reflection.getOrCreateKotlinClass(CircularLayoutManager.class).getSimpleName();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/kapil/circularlayoutmanager/CircularLayoutManager$Companion;", "", "()V", "FILL_START_POSITION", "", "FIRST_CHILD_TOP_OFFSET", "MILLIS_PER_INCH_FAST", "", "MILLIS_PER_INCH_SLOW", "TAG", "circular-layout-manager_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

