/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.examples.boot.config;

import com.github.kagkarlsson.examples.boot.CounterService;
import com.github.kagkarlsson.examples.boot.ExampleContext;
import com.github.kagkarlsson.scheduler.task.Task;
import com.github.kagkarlsson.scheduler.task.TaskDescriptor;
import com.github.kagkarlsson.scheduler.task.helper.Tasks;
import com.github.kagkarlsson.scheduler.task.schedule.Schedule;
import com.github.kagkarlsson.scheduler.task.schedule.Schedules;
import java.time.Duration;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import utils.EventLogger;

@Configuration
public class BasicExamplesConfiguration {
    public static final TaskDescriptor<Void> BASIC_ONE_TIME_TASK = TaskDescriptor.of((String)"sample-one-time-task");
    public static final TaskDescriptor<Void> BASIC_RECURRING_TASK = TaskDescriptor.of((String)"recurring-sample-task");
    private static final Logger log = LoggerFactory.getLogger(BasicExamplesConfiguration.class);
    private static int ID = 1;

    public static void triggerOneTime(ExampleContext ctx) {
        ctx.log("Scheduling a basic one-time task to run 'Instant.now()+seconds'. If seconds=0, the scheduler will pick these up immediately since it is configured with 'immediate-execution-enabled=true'");
        ctx.schedulerClient.scheduleIfNotExists(BASIC_ONE_TIME_TASK.instance(String.valueOf(ID++)).scheduledTo(Instant.now()));
    }

    @Bean
    Task<Void> recurringSampleTask(CounterService counter) {
        return Tasks.recurring(BASIC_RECURRING_TASK, (Schedule)Schedules.fixedDelay((Duration)Duration.ofMinutes(1L))).execute((instance, ctx) -> {
            log.info("Running recurring-simple-task. Instance: {}, ctx: {}", (Object)instance, (Object)ctx);
            counter.increase();
            EventLogger.logTask(BASIC_RECURRING_TASK, "Ran. Run-counter current-value=" + counter.read());
        });
    }

    @Bean
    Task<Void> sampleOneTimeTask() {
        return Tasks.oneTime(BASIC_ONE_TIME_TASK).execute((instance, ctx) -> log.info("I am a one-time task!"));
    }
}

