/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.examples.boot.config;

import com.github.kagkarlsson.examples.boot.ExampleContext;
import com.github.kagkarlsson.scheduler.task.Task;
import com.github.kagkarlsson.scheduler.task.TaskWithDataDescriptor;
import com.github.kagkarlsson.scheduler.task.helper.Tasks;
import com.github.kagkarlsson.scheduler.task.schedule.Schedule;
import com.github.kagkarlsson.scheduler.task.schedule.Schedules;
import java.time.Instant;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import utils.EventLogger;

@Configuration
public class RecurringStateTrackingConfiguration {
    public static final TaskWithDataDescriptor<Integer> STATE_TRACKING_RECURRING_TASK = new TaskWithDataDescriptor("state-tracking-recurring-task", Integer.class);

    public static void start(ExampleContext ctx) {
        Integer data = 1;
        ctx.log("Starting recurring task " + STATE_TRACKING_RECURRING_TASK.getTaskName() + " with initial data: " + data + ". Initial execution-time will be now (deviating from defined schedule).");
        ctx.schedulerClient.schedule(STATE_TRACKING_RECURRING_TASK.instance("recurring", (Object)data), Instant.now());
    }

    @Bean
    public Task<Integer> stateTrackingRecurring() {
        return Tasks.recurring(STATE_TRACKING_RECURRING_TASK, (Schedule)Schedules.cron((String)"0/5 * * * * *")).doNotScheduleOnStartup().executeStateful((taskInstance, executionContext) -> {
            EventLogger.logTask(STATE_TRACKING_RECURRING_TASK, "Ran recurring task. Will keep running according to the same schedule, but the state is updated. State: " + taskInstance.getData());
            return (Integer)taskInstance.getData() + 1;
        });
    }
}

