/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.examples;

import com.github.kagkarlsson.examples.helpers.Example;
import com.github.kagkarlsson.scheduler.Scheduler;
import com.github.kagkarlsson.scheduler.task.AbstractTask;
import com.github.kagkarlsson.scheduler.task.CompletionHandler;
import com.github.kagkarlsson.scheduler.task.ExecutionContext;
import com.github.kagkarlsson.scheduler.task.Task;
import com.github.kagkarlsson.scheduler.task.TaskInstance;
import com.github.kagkarlsson.scheduler.task.helper.CustomTask;
import com.github.kagkarlsson.scheduler.task.helper.OneTimeTask;
import com.github.kagkarlsson.scheduler.task.helper.RecurringTask;
import com.github.kagkarlsson.scheduler.task.helper.Tasks;
import com.github.kagkarlsson.scheduler.task.schedule.FixedDelay;
import com.github.kagkarlsson.scheduler.task.schedule.Schedule;
import java.time.Duration;
import java.time.Instant;
import javax.sql.DataSource;

public class SchedulerMain
extends Example {
    public static void main(String[] args) {
        new SchedulerMain().runWithDatasource();
    }

    @Override
    public void run(DataSource dataSource) {
        RecurringTask recurring1 = Tasks.recurring((String)"recurring_no_data", (Schedule)FixedDelay.of((Duration)Duration.ofSeconds(5L))).onFailureReschedule().onDeadExecutionRevive().execute((taskInstance, executionContext) -> {
            this.sleep(100);
            System.out.println("Executing " + taskInstance.getTaskAndInstance());
        });
        RecurringTask recurring2 = Tasks.recurring((String)"recurring_constant_data", (Schedule)FixedDelay.of((Duration)Duration.ofSeconds(7L)), Integer.class).initialData((Object)1).onFailureReschedule().onDeadExecutionRevive().execute((taskInstance, executionContext) -> {
            this.sleep(100);
            System.out.println("Executing " + taskInstance.getTaskAndInstance() + " , data: " + taskInstance.getData());
        });
        FixedDelay custom1Schedule = FixedDelay.of((Duration)Duration.ofSeconds(4L));
        CustomTask custom1 = Tasks.custom((String)"recurring_changing_data", Integer.class).scheduleOnStartup("instance1", (Object)1, arg_0 -> ((Schedule)custom1Schedule).getInitialExecutionTime(arg_0)).onFailureReschedule((Schedule)custom1Schedule).onDeadExecutionRevive().execute((arg_0, arg_1) -> this.lambda$run$3((Schedule)custom1Schedule, arg_0, arg_1));
        OneTimeTask onetime1 = Tasks.oneTime((String)"onetime_no_data").onDeadExecutionRevive().onFailureRetryLater().execute((taskInstance, executionContext) -> {
            this.sleep(100);
            System.out.println("Executing " + taskInstance.getTaskAndInstance());
        });
        OneTimeTask onetime2 = Tasks.oneTime((String)"onetime_withdata", Integer.class).onFailureRetryLater().execute((taskInstance, executionContext) -> {
            this.sleep(100);
            System.out.println("Executing " + taskInstance.getTaskAndInstance() + " , data: " + taskInstance.getData());
        });
        Scheduler scheduler = Scheduler.create((DataSource)dataSource, (Task[])new Task[]{onetime1, onetime2}).startTasks((Task[])new AbstractTask[]{recurring1, recurring2, custom1}).registerShutdownHook().build();
        scheduler.start();
        this.sleep(3000);
        scheduler.schedule(onetime1.instance("onetime1_directly"), Instant.now());
        scheduler.schedule(onetime2.instance("onetime2", (Object)100), Instant.now().plusSeconds(3L));
        scheduler.schedule(onetime2.instance("onetime3", (Object)100), Instant.now());
    }

    private /* synthetic */ CompletionHandler lambda$run$3(Schedule custom1Schedule, TaskInstance taskInstance, ExecutionContext executionContext) {
        System.out.println("Executing " + taskInstance.getTaskAndInstance() + " , data: " + taskInstance.getData());
        return (executionComplete, executionOperations) -> {
            this.sleep(100);
            Instant nextExecutionTime = custom1Schedule.getNextExecutionTime(executionComplete);
            int newData = (Integer)taskInstance.getData() + 1;
            executionOperations.reschedule(executionComplete, nextExecutionTime, (Object)newData);
        };
    }
}

