/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.examples;

import com.github.kagkarlsson.examples.helpers.Example;
import com.github.kagkarlsson.scheduler.Scheduler;
import com.github.kagkarlsson.scheduler.task.ExecutionComplete;
import com.github.kagkarlsson.scheduler.task.Task;
import com.github.kagkarlsson.scheduler.task.TaskInstanceId;
import com.github.kagkarlsson.scheduler.task.helper.CustomTask;
import com.github.kagkarlsson.scheduler.task.helper.Tasks;
import com.github.kagkarlsson.scheduler.task.schedule.CronSchedule;
import com.github.kagkarlsson.scheduler.task.schedule.Schedule;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import javax.sql.DataSource;

public class PersistentDynamicScheduleMain
extends Example {
    public static void main(String[] args) {
        new PersistentDynamicScheduleMain().runWithDatasource();
    }

    @Override
    public void run(DataSource dataSource) {
        SerializableCronSchedule initialSchedule = new SerializableCronSchedule("*/10 * * * * ?");
        CustomTask task = Tasks.custom((String)"dynamic-recurring-task", SerializableCronSchedule.class).scheduleOnStartup("recurring", (Object)initialSchedule, (Schedule)initialSchedule).onFailure((executionComplete, executionOperations) -> {
            SerializableCronSchedule persistedSchedule = (SerializableCronSchedule)executionComplete.getExecution().taskInstance.getData();
            executionOperations.reschedule(executionComplete, persistedSchedule.getNextExecutionTime(executionComplete));
        }).execute((taskInstance, executionContext) -> {
            SerializableCronSchedule persistentSchedule = (SerializableCronSchedule)taskInstance.getData();
            System.out.println("Ran using persistent schedule: " + persistentSchedule.getCronPattern());
            return (executionComplete, executionOperations) -> executionOperations.reschedule(executionComplete, persistentSchedule.getNextExecutionTime(executionComplete));
        });
        Scheduler scheduler = Scheduler.create((DataSource)dataSource, (Task[])new Task[0]).pollingInterval(Duration.ofSeconds(5L)).startTasks((Task[])new CustomTask[]{task}).registerShutdownHook().build();
        scheduler.start();
        this.sleep(7000);
        SerializableCronSchedule newSchedule = new SerializableCronSchedule("*/15 * * * * ?");
        TaskInstanceId scheduledExecution = TaskInstanceId.of((String)"dynamic-recurring-task", (String)"recurring");
        Instant newNextExecutionTime = newSchedule.getNextExecutionTime(ExecutionComplete.simulatedSuccess((Instant)Instant.now()));
        System.out.println("Simulating dynamic reschedule of recurring task");
        scheduler.reschedule(scheduledExecution, newNextExecutionTime, (Object)newSchedule);
    }

    private void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static class SerializableCronSchedule
    implements Serializable,
    Schedule {
        private final String cronPattern;

        SerializableCronSchedule(String cronPattern) {
            this.cronPattern = cronPattern;
        }

        public Instant getNextExecutionTime(ExecutionComplete executionComplete) {
            return new CronSchedule(this.cronPattern).getNextExecutionTime(executionComplete);
        }

        public boolean isDeterministic() {
            return true;
        }

        public String toString() {
            return "SerializableCronSchedule pattern=" + this.cronPattern;
        }

        public String getCronPattern() {
            return this.cronPattern;
        }
    }
}

