/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.task.helper;

import com.github.kagkarlsson.scheduler.Clock;
import com.github.kagkarlsson.scheduler.Scheduler;
import com.github.kagkarlsson.scheduler.task.Task;
import com.github.kagkarlsson.scheduler.task.TaskInstance;
import com.github.kagkarlsson.scheduler.task.helper.ScheduleOnStartup;
import java.time.Instant;
import java.util.function.Function;

class ScheduleOnceOnStartup<T>
implements ScheduleOnStartup<T> {
    private String instance;
    private T data;
    private Function<Instant, Instant> firstExecutionTime;

    ScheduleOnceOnStartup(String instance) {
        this(instance, null);
    }

    ScheduleOnceOnStartup(String instance, T data) {
        this(instance, data, Function.identity());
    }

    ScheduleOnceOnStartup(String instance, T data, Function<Instant, Instant> firstExecutionTime) {
        this.firstExecutionTime = firstExecutionTime;
        this.instance = instance;
        this.data = data;
    }

    @Override
    public void apply(Scheduler scheduler, Clock clock, Task<T> task) {
        scheduler.schedule(this.getSchedulableInstance(task), this.firstExecutionTime.apply(clock.now()));
    }

    private TaskInstance<T> getSchedulableInstance(Task<T> task) {
        if (this.data == null) {
            return task.instance(this.instance);
        }
        return task.instance(this.instance, this.data);
    }
}

