/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.stats;

import com.github.kagkarlsson.scheduler.stats.StatsRegistry;
import com.github.kagkarlsson.scheduler.task.ExecutionComplete;
import com.github.kagkarlsson.scheduler.task.Task;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class MicrometerStatsRegistry
implements StatsRegistry {
    private static final String RESULT_SUCCESS = "ok";
    private static final String RESULT_FAILURE = "failed";
    private final MeterRegistry meterRegistry;
    private Map<String, MetricsHolder> metricsMap = new HashMap<String, MetricsHolder>();

    public MicrometerStatsRegistry(MeterRegistry meterRegistry, List<? extends Task<?>> expectedTasks) {
        this.meterRegistry = meterRegistry;
        this.initializeMetricsForAllTasks(expectedTasks);
    }

    private void initializeMetricsForAllTasks(List<? extends Task<?>> expectedTasks) {
        expectedTasks.forEach(task -> this.getOrInitMetricHolder(task.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MetricsHolder getOrInitMetricHolder(String taskName) {
        MetricsHolder preSynchronizedValue = this.metricsMap.get(taskName);
        if (preSynchronizedValue != null) {
            return preSynchronizedValue;
        }
        MicrometerStatsRegistry micrometerStatsRegistry = this;
        synchronized (micrometerStatsRegistry) {
            MetricsHolder currentValue = this.metricsMap.get(taskName);
            if (currentValue == null) {
                currentValue = new MetricsHolder(taskName);
                this.metricsMap.put(taskName, currentValue);
            }
            return currentValue;
        }
    }

    @Override
    public void register(StatsRegistry.SchedulerStatsEvent e) {
    }

    @Override
    public void register(StatsRegistry.CandidateStatsEvent e) {
    }

    @Override
    public void register(StatsRegistry.ExecutionStatsEvent e) {
    }

    @Override
    public void registerSingleCompletedExecution(ExecutionComplete completeEvent) {
        String taskName = completeEvent.getExecution().taskInstance.getTaskName();
        MetricsHolder metrics = this.getOrInitMetricHolder(taskName);
        metrics.registerExecution(completeEvent);
    }

    private class MetricsHolder {
        private final AtomicReference<Double> lastDurationForTask = new AtomicReference<Double>(0.0);
        private final AtomicLong lastRunTimestampForTask = new AtomicLong(0L);
        private final Counter successesForTask;
        private final Counter failuresForTask;
        private final Timer durationsForTask;

        MetricsHolder(String taskName) {
            Gauge.builder((String)"dbscheduler_task_last_run_duration", this.lastDurationForTask::get).description("Duration in seconds for last execution of this task").tag("task", taskName).register(MicrometerStatsRegistry.this.meterRegistry);
            Gauge.builder((String)"dbscheduler_task_last_run_timestamp_seconds", this.lastRunTimestampForTask::get).description("Time when last run completed").tag("task", taskName).register(MicrometerStatsRegistry.this.meterRegistry);
            this.successesForTask = Counter.builder((String)"dbscheduler_task_completions").description("Successes and failures by task").tag("task", taskName).tag("result", MicrometerStatsRegistry.RESULT_SUCCESS).register(MicrometerStatsRegistry.this.meterRegistry);
            this.failuresForTask = Counter.builder((String)"dbscheduler_task_completions").description("Successes and failures by task").tag("task", taskName).tag("result", MicrometerStatsRegistry.RESULT_FAILURE).register(MicrometerStatsRegistry.this.meterRegistry);
            this.durationsForTask = Timer.builder((String)"dbscheduler_task_duration").description("Duration of executions").tag("task", taskName).register(MicrometerStatsRegistry.this.meterRegistry);
        }

        void registerExecution(ExecutionComplete completeEvent) {
            this.lastDurationForTask.set((double)completeEvent.getDuration().toNanos() / 1.0E9);
            this.lastRunTimestampForTask.set(completeEvent.getTimeDone().getEpochSecond());
            this.durationsForTask.record(completeEvent.getDuration().toMillis(), TimeUnit.MILLISECONDS);
            if (completeEvent.getResult() == ExecutionComplete.Result.OK) {
                this.successesForTask.increment();
            } else {
                this.failuresForTask.increment();
            }
        }
    }
}

