/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.testhelper;

import com.github.kagkarlsson.scheduler.Scheduler;
import com.github.kagkarlsson.scheduler.SchedulerName;
import com.github.kagkarlsson.scheduler.TaskRepository;
import com.github.kagkarlsson.scheduler.TaskResolver;
import com.github.kagkarlsson.scheduler.Waiter;
import com.github.kagkarlsson.scheduler.stats.StatsRegistry;
import com.github.kagkarlsson.scheduler.task.OnStartup;
import com.github.kagkarlsson.scheduler.testhelper.SettableClock;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManualScheduler
extends Scheduler {
    private static final Logger LOG = LoggerFactory.getLogger(ManualScheduler.class);
    private final SettableClock clock;

    ManualScheduler(SettableClock clock, TaskRepository schedulerTaskRepository, TaskRepository clientTaskRepository, TaskResolver taskResolver, int maxThreads, ExecutorService executorService, SchedulerName schedulerName, Waiter waiter, Duration heartbeatInterval, boolean executeImmediately, StatsRegistry statsRegistry, int pollingLimit, Duration deleteUnresolvedAfter, List<OnStartup> onStartup) {
        super(clock, schedulerTaskRepository, clientTaskRepository, taskResolver, maxThreads, executorService, schedulerName, waiter, heartbeatInterval, executeImmediately, statsRegistry, pollingLimit, deleteUnresolvedAfter, Duration.ZERO, onStartup);
        this.clock = clock;
    }

    public SettableClock getClock() {
        return this.clock;
    }

    public void tick(Duration moveClockForward) {
        this.clock.set(this.clock.now.plus(moveClockForward));
    }

    public void setTime(Instant newtime) {
        this.clock.set(newtime);
    }

    public void runAnyDueExecutions() {
        super.executeDue();
    }

    public void runDeadExecutionDetection() {
        super.detectDeadExecutions();
    }

    @Override
    public void start() {
        LOG.info("Starting manual scheduler. Executing on-startup tasks.");
        this.executeOnStartup();
    }
}

