/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler;

import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DueExecutionsBatch {
    private static final Logger LOG = LoggerFactory.getLogger(DueExecutionsBatch.class);
    private final int generationNumber;
    private final AtomicInteger executionsLeftInBatch;
    private int threadpoolSize;
    private boolean possiblyMoreExecutionsInDb;
    private boolean stale = false;
    private boolean triggeredExecuteDue;

    public DueExecutionsBatch(int threadpoolSize, int generationNumber, int executionsAdded, boolean possiblyMoreExecutionsInDb) {
        this.threadpoolSize = threadpoolSize;
        this.generationNumber = generationNumber;
        this.possiblyMoreExecutionsInDb = possiblyMoreExecutionsInDb;
        this.executionsLeftInBatch = new AtomicInteger(executionsAdded);
    }

    public void markBatchAsStale() {
        this.stale = true;
    }

    public void oneExecutionDone(Runnable triggerCheckForNewBatch) {
        this.executionsLeftInBatch.decrementAndGet();
        LOG.trace("Batch state: generationNumber:{}, stale:{}, triggeredExecuteDue:{}, possiblyMoreExecutionsInDb:{}, executionsLeftInBatch:{}, ratio-trigger:{}", new Object[]{this.generationNumber, this.stale, this.triggeredExecuteDue, this.possiblyMoreExecutionsInDb, this.executionsLeftInBatch.get(), (double)this.threadpoolSize * 0.5});
        if (!this.stale && !this.triggeredExecuteDue && this.possiblyMoreExecutionsInDb && (double)this.executionsLeftInBatch.get() <= (double)this.threadpoolSize * 0.5) {
            LOG.trace("Triggering check for new batch.");
            triggerCheckForNewBatch.run();
            this.triggeredExecuteDue = true;
        }
    }

    public boolean isOlderGenerationThan(int compareTo) {
        return this.generationNumber < compareTo;
    }

    public int getGenerationNumber() {
        return this.generationNumber;
    }
}

