/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.task.schedule;

import com.github.kagkarlsson.scheduler.task.ExecutionComplete;
import com.github.kagkarlsson.scheduler.task.schedule.Schedule;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;

public class FixedDelay
implements Schedule {
    private final Duration duration;

    private FixedDelay(Duration duration) {
        this.duration = Objects.requireNonNull(duration);
    }

    public static FixedDelay of(Duration duration) {
        return new FixedDelay(duration);
    }

    public static FixedDelay ofSeconds(int seconds) {
        FixedDelay.validateDuration(seconds);
        return new FixedDelay(Duration.ofSeconds(seconds));
    }

    public static FixedDelay ofMinutes(int minutes) {
        FixedDelay.validateDuration(minutes);
        return new FixedDelay(Duration.ofMinutes(minutes));
    }

    public static FixedDelay ofHours(int hours) {
        FixedDelay.validateDuration(hours);
        return new FixedDelay(Duration.ofHours(hours));
    }

    private static void validateDuration(int seconds) {
        if (seconds <= 0) {
            throw new IllegalArgumentException("argument must be greater than 0");
        }
    }

    @Override
    public Instant getNextExecutionTime(ExecutionComplete executionComplete) {
        return executionComplete.getTimeDone().plus(this.duration);
    }

    @Override
    public Instant getInitialExecutionTime(Instant now) {
        return now;
    }

    @Override
    public boolean isDeterministic() {
        return false;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FixedDelay)) {
            return false;
        }
        FixedDelay that = (FixedDelay)o;
        return Objects.equals(this.duration, that.duration);
    }

    public final int hashCode() {
        return Objects.hash(this.duration);
    }

    public String toString() {
        return "FixedDelay duration=" + this.duration;
    }
}

