/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.task.schedule;

import com.github.kagkarlsson.scheduler.task.ExecutionComplete;
import com.github.kagkarlsson.scheduler.task.schedule.Schedule;
import com.github.kagkarlsson.shaded.cronutils.model.Cron;
import com.github.kagkarlsson.shaded.cronutils.model.CronType;
import com.github.kagkarlsson.shaded.cronutils.model.definition.CronDefinitionBuilder;
import com.github.kagkarlsson.shaded.cronutils.model.time.ExecutionTime;
import com.github.kagkarlsson.shaded.cronutils.parser.CronParser;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CronSchedule
implements Schedule {
    private static final Logger LOG = LoggerFactory.getLogger(CronSchedule.class);
    private final ExecutionTime cronExecutionTime;
    private final ZoneId zoneId;

    public CronSchedule(String pattern, ZoneId zoneId) {
        CronParser parser = new CronParser(CronDefinitionBuilder.instanceDefinitionFor(CronType.SPRING));
        Cron cron = parser.parse(pattern);
        this.cronExecutionTime = ExecutionTime.forCron(cron);
        if (zoneId == null) {
            throw new IllegalArgumentException("zoneId may not be null");
        }
        this.zoneId = zoneId;
    }

    public CronSchedule(String pattern) {
        this(pattern, ZoneId.systemDefault());
    }

    @Override
    public Instant getNextExecutionTime(ExecutionComplete executionComplete) {
        ZonedDateTime lastDone = ZonedDateTime.ofInstant(executionComplete.getTimeDone(), this.zoneId);
        Optional<ZonedDateTime> nextTime = this.cronExecutionTime.nextExecution(lastDone);
        if (!nextTime.isPresent()) {
            LOG.error("Cron-pattern did not return any further execution-times. This behavior is currently not supported by the scheduler. Setting next execution-time to far-future.");
            return Instant.now().plus(1000L, ChronoUnit.YEARS);
        }
        return nextTime.get().toInstant();
    }
}

