/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.shaded.cronutils.parser;

import com.github.kagkarlsson.shaded.cronutils.model.field.CronField;
import com.github.kagkarlsson.shaded.cronutils.model.field.CronFieldName;
import com.github.kagkarlsson.shaded.cronutils.model.field.constraint.FieldConstraints;
import com.github.kagkarlsson.shaded.cronutils.parser.FieldParser;
import com.github.kagkarlsson.shaded.cronutils.utils.Preconditions;
import java.util.Comparator;

public class CronParserField {
    private final CronFieldName field;
    private final FieldConstraints constraints;
    private final FieldParser parser;
    private final boolean optional;

    public CronParserField(CronFieldName fieldName, FieldConstraints constraints) {
        this(fieldName, constraints, false);
    }

    public CronParserField(CronFieldName fieldName, FieldConstraints constraints, boolean optional) {
        this.field = Preconditions.checkNotNull(fieldName, "CronFieldName must not be null");
        this.constraints = Preconditions.checkNotNull(constraints, "FieldConstraints must not be null");
        this.parser = new FieldParser(constraints);
        this.optional = optional;
    }

    public CronFieldName getField() {
        return this.field;
    }

    public final boolean isOptional() {
        return this.optional;
    }

    public CronField parse(String expression) {
        return new CronField(this.field, this.parser.parse(expression), this.constraints);
    }

    public static Comparator<CronParserField> createFieldTypeComparator() {
        return Comparator.comparingInt(o -> o.getField().getOrder());
    }

    public String toString() {
        return "CronParserField{field=" + (Object)((Object)this.field) + '}';
    }
}

