/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.task.schedule;

import com.github.kagkarlsson.scheduler.task.schedule.CronSchedule;
import com.github.kagkarlsson.scheduler.task.schedule.Daily;
import com.github.kagkarlsson.scheduler.task.schedule.FixedDelay;
import com.github.kagkarlsson.scheduler.task.schedule.Schedule;
import java.time.Duration;
import java.time.LocalTime;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Schedules {
    private static final Pattern DAILY_PATTERN = Pattern.compile("^DAILY\\|((\\d{2}:\\d{2})(,\\d{2}:\\d{2})*)$");
    private static final Pattern FIXED_DELAY_PATTERN = Pattern.compile("^FIXED_DELAY\\|(\\d+)s$");

    public static Schedule daily(LocalTime ... times) {
        return new Daily(times);
    }

    public static Schedule fixedDelay(Duration delay) {
        return FixedDelay.of(delay);
    }

    public static Schedule cron(String cronPattern) {
        return new CronSchedule(cronPattern);
    }

    public static Schedule parseSchedule(String scheduleString) {
        if (scheduleString == null) {
            throw new UnrecognizableSchedule("null");
        }
        Matcher dailyMatcher = DAILY_PATTERN.matcher(scheduleString);
        if (dailyMatcher.matches()) {
            String[] times = dailyMatcher.group(1).split(",");
            List<LocalTime> parsedTimes = Stream.of(times).map(timeStr -> {
                String[] hourAndMinute = timeStr.split(":");
                return LocalTime.of(Integer.parseInt(hourAndMinute[0]), Integer.parseInt(hourAndMinute[1]));
            }).collect(Collectors.toList());
            return new Daily(parsedTimes);
        }
        Matcher fixedDelayMatcher = FIXED_DELAY_PATTERN.matcher(scheduleString);
        if (fixedDelayMatcher.matches()) {
            int secondsDelay = Integer.parseInt(fixedDelayMatcher.group(1));
            return FixedDelay.of(Duration.ofSeconds(secondsDelay));
        }
        throw new UnrecognizableSchedule(scheduleString);
    }

    public static class UnrecognizableSchedule
    extends RuntimeException {
        public UnrecognizableSchedule(String inputSchedule) {
            super("Unrecognized schedule: '" + inputSchedule + "'");
        }
    }
}

