/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.task;

import com.github.kagkarlsson.scheduler.task.TaskInstanceId;
import java.util.function.Supplier;

public final class TaskInstance<T>
implements TaskInstanceId {
    private final String taskName;
    private final String id;
    private final Supplier<T> dataSupplier;

    public TaskInstance(String taskName, String id) {
        this(taskName, id, null);
    }

    public TaskInstance(String taskName, String id, T data) {
        this(taskName, id, () -> data);
    }

    public TaskInstance(String taskName, String id, Supplier<T> dataSupplier) {
        this.taskName = taskName;
        this.id = id;
        this.dataSupplier = dataSupplier;
    }

    public String getTaskAndInstance() {
        return this.taskName + "_" + this.id;
    }

    @Override
    public String getTaskName() {
        return this.taskName;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public T getData() {
        return this.dataSupplier.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskInstance that = (TaskInstance)o;
        if (!this.taskName.equals(that.taskName)) {
            return false;
        }
        return this.id.equals(that.id);
    }

    public int hashCode() {
        int result = this.taskName.hashCode();
        result = 31 * result + this.id.hashCode();
        return result;
    }

    public String toString() {
        return "TaskInstance: task=" + this.taskName + ", id=" + this.id;
    }
}

