/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.task;

import com.github.kagkarlsson.scheduler.task.TaskInstance;
import java.time.Instant;
import java.util.Objects;

public final class Execution {
    public final TaskInstance taskInstance;
    public final Instant executionTime;
    public boolean picked;
    public String pickedBy;
    public Instant lastHeartbeat;
    public long version;
    public Instant lastFailure;
    public Instant lastSuccess;

    public Execution(Instant executionTime, TaskInstance taskInstance) {
        this(executionTime, taskInstance, false, null, null, null, null, 1L);
    }

    public Execution(Instant executionTime, TaskInstance taskInstance, boolean picked, String pickedBy, Instant lastSuccess, Instant lastFailure, Instant lastHeartbeat, long version) {
        this.executionTime = executionTime;
        this.taskInstance = taskInstance;
        this.picked = picked;
        this.pickedBy = pickedBy;
        this.lastFailure = lastFailure;
        this.lastSuccess = lastSuccess;
        this.lastHeartbeat = lastHeartbeat;
        this.version = version;
    }

    public void setPicked(String pickedBy, Instant timePicked) {
        this.pickedBy = pickedBy;
        this.picked = true;
        this.lastHeartbeat = timePicked;
    }

    public Instant getExecutionTime() {
        return this.executionTime;
    }

    public boolean isPicked() {
        return this.picked;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Execution execution = (Execution)o;
        return Objects.equals(this.executionTime, execution.executionTime) && Objects.equals(this.taskInstance, execution.taskInstance);
    }

    public int hashCode() {
        return Objects.hash(this.executionTime, this.taskInstance);
    }

    public String toString() {
        return "Execution: task=" + this.taskInstance.getTask().getName() + ", id=" + this.taskInstance.getId() + ", executionTime=" + this.executionTime + ", picked=" + this.picked + ", pickedBy=" + this.pickedBy + ", lastHeartbeat=" + this.lastHeartbeat + ", version=" + this.version;
    }
}

