/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.task;

import com.github.kagkarlsson.scheduler.task.ExecutionComplete;
import com.github.kagkarlsson.scheduler.task.ExecutionOperations;
import com.github.kagkarlsson.scheduler.task.SchedulableInstance;
import com.github.kagkarlsson.scheduler.task.TaskDescriptor;
import com.github.kagkarlsson.scheduler.task.TaskInstance;
import com.github.kagkarlsson.scheduler.task.schedule.Schedule;
import java.time.Instant;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface CompletionHandler<T> {
    public void complete(ExecutionComplete var1, ExecutionOperations<T> var2);

    public static class OnCompleteReplace<CURRENT_TYPE, NEXT_TYPE>
    implements CompletionHandler<CURRENT_TYPE> {
        private static final Logger LOG = LoggerFactory.getLogger(OnCompleteReplace.class);
        private String newTaskName = "<hidden>";
        private final Function<TaskInstance<CURRENT_TYPE>, SchedulableInstance<NEXT_TYPE>> newInstanceCreator;

        public OnCompleteReplace(String newTaskName) {
            this(newTaskName, null);
        }

        public OnCompleteReplace(String newTaskName, NEXT_TYPE newData) {
            this((TaskInstance<CURRENT_TYPE> currentInstance) -> SchedulableInstance.of(new TaskInstance<Object>(newTaskName, currentInstance.getId(), newData), Instant.now()));
            this.newTaskName = newTaskName;
        }

        public OnCompleteReplace(TaskDescriptor<NEXT_TYPE> newTask, NEXT_TYPE newData) {
            this((TaskInstance<CURRENT_TYPE> currentInstance) -> newTask.instance(currentInstance.getId()).data(newData).scheduledTo(Instant.now()));
            this.newTaskName = newTask.getTaskName();
        }

        public OnCompleteReplace(Function<TaskInstance<CURRENT_TYPE>, SchedulableInstance<NEXT_TYPE>> newInstanceCreator) {
            this.newInstanceCreator = newInstanceCreator;
        }

        @Override
        public void complete(ExecutionComplete executionComplete, ExecutionOperations<CURRENT_TYPE> executionOperations) {
            TaskInstance currentInstance = executionComplete.getExecution().taskInstance;
            SchedulableInstance<NEXT_TYPE> nextInstance = this.newInstanceCreator.apply(currentInstance);
            LOG.debug("Removing instance {} and scheduling instance {}", (Object)executionComplete.getExecution().taskInstance, nextInstance);
            executionOperations.removeAndScheduleNew(nextInstance);
        }

        public String toString() {
            return "OnCompleteReplace with task '" + this.newTaskName + "'";
        }
    }

    public static class OnCompleteReschedule<T>
    implements CompletionHandler<T> {
        private static final Logger LOG = LoggerFactory.getLogger(OnCompleteReschedule.class);
        private final Schedule schedule;
        private final boolean setNewData;
        private T newData;

        public OnCompleteReschedule(Schedule schedule) {
            this.schedule = schedule;
            this.setNewData = false;
        }

        public OnCompleteReschedule(Schedule schedule, T newData) {
            this.schedule = schedule;
            this.newData = newData;
            this.setNewData = true;
        }

        @Override
        public void complete(ExecutionComplete executionComplete, ExecutionOperations<T> executionOperations) {
            Instant nextExecution = this.schedule.getNextExecutionTime(executionComplete);
            LOG.debug("Rescheduling task {} to {}", (Object)executionComplete.getExecution().taskInstance, (Object)nextExecution);
            if (this.setNewData) {
                executionOperations.reschedule(executionComplete, nextExecution, this.newData);
            } else {
                executionOperations.reschedule(executionComplete, nextExecution);
            }
        }

        public String toString() {
            return "OnCompleteReschedule with " + String.valueOf(this.schedule);
        }
    }

    public static class OnCompleteRemove<T>
    implements CompletionHandler<T> {
        @Override
        public void complete(ExecutionComplete executionComplete, ExecutionOperations<T> executionOperations) {
            executionOperations.stop();
        }
    }
}

