/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.task;

import com.github.kagkarlsson.scheduler.TaskRepository;
import com.github.kagkarlsson.scheduler.event.SchedulerListeners;
import com.github.kagkarlsson.scheduler.task.Execution;
import com.github.kagkarlsson.scheduler.task.ExecutionComplete;
import com.github.kagkarlsson.scheduler.task.SchedulableInstance;
import com.github.kagkarlsson.scheduler.task.TaskInstanceId;
import java.time.Instant;

public class ExecutionOperations<T> {
    private final TaskRepository taskRepository;
    private final SchedulerListeners schedulerListeners;
    private final Execution execution;

    public ExecutionOperations(TaskRepository taskRepository, SchedulerListeners schedulerListeners, Execution execution) {
        this.taskRepository = taskRepository;
        this.schedulerListeners = schedulerListeners;
        this.execution = execution;
    }

    public void stop() {
        this.remove();
    }

    public void remove() {
        this.taskRepository.remove(this.execution);
    }

    public void removeAndScheduleNew(SchedulableInstance<?> schedulableInstance) {
        Instant executionTime = this.taskRepository.replace(this.execution, schedulableInstance);
        this.hintExecutionScheduled(schedulableInstance.getTaskInstance(), executionTime);
    }

    public void reschedule(ExecutionComplete completed, Instant nextExecutionTime) {
        if (completed.getResult() == ExecutionComplete.Result.OK) {
            this.taskRepository.reschedule(this.execution, nextExecutionTime, completed.getTimeDone(), this.execution.lastFailure, 0);
        } else {
            this.taskRepository.reschedule(this.execution, nextExecutionTime, this.execution.lastSuccess, completed.getTimeDone(), this.execution.consecutiveFailures + 1);
        }
        this.hintExecutionScheduled(completed.getExecution().taskInstance, nextExecutionTime);
    }

    public void reschedule(ExecutionComplete completed, Instant nextExecutionTime, T newData) {
        if (completed.getResult() == ExecutionComplete.Result.OK) {
            this.taskRepository.reschedule(this.execution, nextExecutionTime, newData, completed.getTimeDone(), this.execution.lastFailure, 0);
        } else {
            this.taskRepository.reschedule(this.execution, nextExecutionTime, newData, this.execution.lastSuccess, completed.getTimeDone(), this.execution.consecutiveFailures + 1);
        }
        this.hintExecutionScheduled(completed.getExecution().taskInstance, nextExecutionTime);
    }

    private void hintExecutionScheduled(TaskInstanceId taskInstanceId, Instant nextExecutionTime) {
        this.schedulerListeners.onExecutionScheduled(taskInstanceId, nextExecutionTime);
    }
}

