/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.task.schedule;

import com.github.kagkarlsson.scheduler.task.schedule.CompositeParser;
import com.github.kagkarlsson.scheduler.task.schedule.CronSchedule;
import com.github.kagkarlsson.scheduler.task.schedule.Daily;
import com.github.kagkarlsson.scheduler.task.schedule.DailyParser;
import com.github.kagkarlsson.scheduler.task.schedule.DisabledScheduleParser;
import com.github.kagkarlsson.scheduler.task.schedule.FixedDelay;
import com.github.kagkarlsson.scheduler.task.schedule.FixedDelayParser;
import com.github.kagkarlsson.scheduler.task.schedule.Parser;
import com.github.kagkarlsson.scheduler.task.schedule.Schedule;
import java.time.Duration;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.List;

public class Schedules {
    private static final Parser SCHEDULE_PARSER = CompositeParser.of(new FixedDelayParser(), new DailyParser(), new DisabledScheduleParser());

    public static Daily daily(LocalTime ... times) {
        return new Daily(times);
    }

    public static Daily daily(ZoneId zone, LocalTime ... times) {
        return new Daily(zone, times);
    }

    public static FixedDelay fixedDelay(Duration delay) {
        return FixedDelay.of(delay);
    }

    public static CronSchedule cron(String cronPattern) {
        return new CronSchedule(cronPattern);
    }

    public static CronSchedule cron(String cronPattern, ZoneId zoneId) {
        return new CronSchedule(cronPattern, zoneId);
    }

    public static Schedule parseSchedule(String scheduleString) {
        return SCHEDULE_PARSER.parse(scheduleString).orElseThrow(() -> new UnrecognizableSchedule(scheduleString, SCHEDULE_PARSER.examples()));
    }

    public static class UnrecognizableSchedule
    extends RuntimeException {
        public UnrecognizableSchedule(String inputSchedule) {
            super("Unrecognized schedule: '" + inputSchedule + "'");
        }

        public UnrecognizableSchedule(String inputSchedule, List<String> examples) {
            super("Unrecognized schedule: '" + inputSchedule + "'. Parsable examples: " + String.valueOf(examples));
        }
    }
}

