/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.task.helper;

import com.github.kagkarlsson.scheduler.task.AbstractTask;
import com.github.kagkarlsson.scheduler.task.CompletionHandler;
import com.github.kagkarlsson.scheduler.task.DeadExecutionHandler;
import com.github.kagkarlsson.scheduler.task.ExecutionContext;
import com.github.kagkarlsson.scheduler.task.FailureHandler;
import com.github.kagkarlsson.scheduler.task.SchedulableInstance;
import com.github.kagkarlsson.scheduler.task.SchedulableTaskInstance;
import com.github.kagkarlsson.scheduler.task.TaskInstance;
import java.time.Duration;

public abstract class OneTimeTask<T>
extends AbstractTask<T> {
    public static final int DEFAULT_PRIORITY = 50;

    public OneTimeTask(String name, Class<T> dataClass) {
        this(name, dataClass, new FailureHandler.OnFailureRetryLater(Duration.ofMinutes(5L)), new DeadExecutionHandler.ReviveDeadExecution());
    }

    public OneTimeTask(String name, Class<T> dataClass, FailureHandler<T> failureHandler) {
        this(name, dataClass, failureHandler, new DeadExecutionHandler.ReviveDeadExecution());
    }

    public OneTimeTask(String name, Class<T> dataClass, FailureHandler<T> failureHandler, DeadExecutionHandler<T> deadExecutionHandler) {
        this(name, dataClass, failureHandler, deadExecutionHandler, 50);
    }

    public OneTimeTask(String name, Class<T> dataClass, FailureHandler<T> failureHandler, DeadExecutionHandler<T> deadExecutionHandler, int defaultPriority) {
        super(name, dataClass, failureHandler, deadExecutionHandler, defaultPriority);
    }

    @Override
    public SchedulableInstance<T> schedulableInstance(String id) {
        return new SchedulableTaskInstance(this.instanceBuilder(id).build(), currentTime -> currentTime);
    }

    @Override
    public SchedulableInstance<T> schedulableInstance(String id, T data) {
        return new SchedulableTaskInstance(this.instanceBuilder(id).data(data).build(), currentTime -> currentTime);
    }

    @Override
    public CompletionHandler<T> execute(TaskInstance<T> taskInstance, ExecutionContext executionContext) {
        this.executeOnce(taskInstance, executionContext);
        return new CompletionHandler.OnCompleteRemove();
    }

    public abstract void executeOnce(TaskInstance<T> var1, ExecutionContext var2);

    @Override
    public String toString() {
        return "OneTimeTask name=" + this.getName();
    }
}

