/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.task;

import com.github.kagkarlsson.scheduler.task.HasTaskName;
import com.github.kagkarlsson.scheduler.task.TaskInstance;
import com.github.kagkarlsson.scheduler.task.TaskInstanceId;

public interface TaskDescriptor<T>
extends HasTaskName {
    @Override
    public String getTaskName();

    public Class<T> getDataClass();

    public static TaskDescriptor<Void> of(String name) {
        return TaskDescriptor.of(name, Void.class);
    }

    public static <T> TaskDescriptor<T> of(String name, Class<T> dataClass) {
        return new SimpleTaskDescriptor<T>(name, dataClass);
    }

    default public TaskInstance.Builder<T> instance(String id) {
        return new TaskInstance.Builder(this.getTaskName(), id);
    }

    default public TaskInstanceId instanceId(String id) {
        return TaskInstanceId.of(this.getTaskName(), id);
    }

    public static class SimpleTaskDescriptor<T>
    implements TaskDescriptor<T> {
        private final String name;
        private final Class<T> dataClass;

        public SimpleTaskDescriptor(String name, Class<T> dataClass) {
            this.name = name;
            this.dataClass = dataClass;
        }

        @Override
        public String getTaskName() {
            return this.name;
        }

        @Override
        public Class<T> getDataClass() {
            return this.dataClass;
        }
    }
}

