/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.jdbc;

import com.github.kagkarlsson.scheduler.jdbc.AndCondition;
import com.github.kagkarlsson.shaded.jdbc.PreparedStatementSetter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

class QueryBuilder {
    private final String tableName;
    private final List<AndCondition> andConditions = new ArrayList<AndCondition>();
    private Optional<String> orderBy = Optional.empty();

    QueryBuilder(String tableName) {
        this.tableName = tableName;
    }

    static QueryBuilder selectFromTable(String tableName) {
        return new QueryBuilder(tableName);
    }

    QueryBuilder andCondition(AndCondition andCondition) {
        this.andConditions.add(andCondition);
        return this;
    }

    QueryBuilder orderBy(String orderBy) {
        this.orderBy = Optional.of(orderBy);
        return this;
    }

    String getQuery() {
        StringBuilder s = new StringBuilder();
        s.append("select * from ").append(this.tableName);
        if (!this.andConditions.isEmpty()) {
            s.append(" where ");
            s.append(this.andConditions.stream().map(AndCondition::getQueryPart).collect(Collectors.joining(" and ")));
        }
        this.orderBy.ifPresent(o -> s.append(" order by ").append((String)o));
        return s.toString();
    }

    PreparedStatementSetter getPreparedStatementSetter() {
        return p -> {
            int parameterIndex = 1;
            for (AndCondition andCondition : this.andConditions) {
                parameterIndex = andCondition.setParameters(p, parameterIndex);
            }
        };
    }
}

