/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.event;

import com.github.kagkarlsson.scheduler.CurrentlyExecuting;
import com.github.kagkarlsson.scheduler.event.SchedulerListener;
import com.github.kagkarlsson.scheduler.task.Execution;
import com.github.kagkarlsson.scheduler.task.ExecutionComplete;
import com.github.kagkarlsson.scheduler.task.TaskInstanceId;
import java.time.Instant;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerListeners
implements SchedulerListener {
    public static final SchedulerListeners NOOP = new SchedulerListeners(List.of());
    private static final Logger LOG = LoggerFactory.getLogger(SchedulerListeners.class);
    private final List<SchedulerListener> schedulerListeners;

    public SchedulerListeners(List<SchedulerListener> schedulerListeners) {
        this.schedulerListeners = schedulerListeners;
    }

    public void add(SchedulerListener listener) {
        this.schedulerListeners.add(listener);
    }

    @Override
    public void onExecutionScheduled(TaskInstanceId taskInstanceId, Instant executionTime) {
        this.schedulerListeners.forEach(listener -> this.fireAndLogErrors((SchedulerListener)listener, "onExecutionScheduled", () -> listener.onExecutionScheduled(taskInstanceId, executionTime)));
    }

    @Override
    public void onExecutionStart(CurrentlyExecuting currentlyExecuting) {
        this.schedulerListeners.forEach(listener -> this.fireAndLogErrors((SchedulerListener)listener, "onExecutionStart", () -> listener.onExecutionStart(currentlyExecuting)));
    }

    @Override
    public void onExecutionComplete(ExecutionComplete executionComplete) {
        this.schedulerListeners.forEach(listener -> this.fireAndLogErrors((SchedulerListener)listener, "onExecutionComplete", () -> listener.onExecutionComplete(executionComplete)));
    }

    @Override
    public void onExecutionDead(Execution execution) {
        this.schedulerListeners.forEach(listener -> this.fireAndLogErrors((SchedulerListener)listener, "onExecutionDead", () -> listener.onExecutionDead(execution)));
    }

    @Override
    public void onExecutionFailedHeartbeat(CurrentlyExecuting currentlyExecuting) {
        this.schedulerListeners.forEach(listener -> this.fireAndLogErrors((SchedulerListener)listener, "onExecutionFailedHeartbeat", () -> listener.onExecutionFailedHeartbeat(currentlyExecuting)));
    }

    @Override
    public void onSchedulerEvent(SchedulerListener.SchedulerEventType type) {
        this.schedulerListeners.forEach(listener -> this.fireAndLogErrors((SchedulerListener)listener, "onSchedulerEvent", () -> listener.onSchedulerEvent(type)));
    }

    @Override
    public void onCandidateEvent(SchedulerListener.CandidateEventType type) {
        this.schedulerListeners.forEach(listener -> this.fireAndLogErrors((SchedulerListener)listener, "onCandidateEvent", () -> listener.onCandidateEvent(type)));
    }

    public void fireAndLogErrors(SchedulerListener listener, String method, Runnable r) {
        try {
            r.run();
        }
        catch (Throwable e) {
            LOG.warn("Listener '{}' method '{}' threw an unexpected Exception", (Object)listener.getClass().getName(), (Object)method);
        }
    }
}

