/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.event;

import com.github.kagkarlsson.scheduler.event.ExecutionInterceptor;
import com.github.kagkarlsson.scheduler.task.CompletionHandler;
import com.github.kagkarlsson.scheduler.task.ExecutionContext;
import com.github.kagkarlsson.scheduler.task.ExecutionHandler;
import com.github.kagkarlsson.scheduler.task.TaskInstance;
import java.util.List;

public class ExecutionChain {
    private final List<ExecutionInterceptor> interceptors;
    private final ExecutionHandler<?> executionHandler;

    public ExecutionChain(List<ExecutionInterceptor> interceptors, ExecutionHandler<?> executionHandler) {
        this.interceptors = interceptors;
        this.executionHandler = executionHandler;
    }

    public CompletionHandler<?> proceed(TaskInstance taskInstance, ExecutionContext executionContext) {
        if (this.interceptors.isEmpty()) {
            return this.executionHandler.execute(taskInstance, executionContext);
        }
        ExecutionInterceptor nextInterceptor = this.interceptors.get(0);
        List<ExecutionInterceptor> rest = this.interceptors.subList(1, this.interceptors.size());
        return nextInterceptor.execute(taskInstance, executionContext, new ExecutionChain(rest, this.executionHandler));
    }
}

