/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler;

import com.github.kagkarlsson.scheduler.Clock;
import com.github.kagkarlsson.scheduler.Scheduler;
import com.github.kagkarlsson.scheduler.SchedulerState;
import com.github.kagkarlsson.scheduler.event.AbstractSchedulerListener;
import com.github.kagkarlsson.scheduler.task.TaskInstanceId;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ImmediateCheckForDueExecutions
extends AbstractSchedulerListener {
    private static final Logger LOG = LoggerFactory.getLogger(ImmediateCheckForDueExecutions.class);
    private final Scheduler scheduler;
    private Clock clock;

    public ImmediateCheckForDueExecutions(Scheduler scheduler, Clock clock) {
        this.scheduler = scheduler;
        this.clock = clock;
    }

    @Override
    public void onExecutionScheduled(TaskInstanceId taskInstanceId, Instant scheduledToExecutionTime) {
        SchedulerState schedulerState = this.scheduler.getSchedulerState();
        if (!schedulerState.isStarted() || schedulerState.isShuttingDown()) {
            LOG.debug("Will not act on scheduling event for execution (task: '{}', id: '{}') as scheduler is starting or shutting down.", (Object)taskInstanceId.getTaskName(), (Object)taskInstanceId.getId());
            return;
        }
        if (scheduledToExecutionTime.toEpochMilli() <= this.clock.now().toEpochMilli()) {
            LOG.debug("Task-instance scheduled to run directly, triggering check for due executions (unless it is already running). Task: {}, instance: {}", (Object)taskInstanceId.getTaskName(), (Object)taskInstanceId.getId());
            this.scheduler.triggerCheckForDueExecutions();
        }
    }
}

