/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.jdbc;

import com.github.kagkarlsson.scheduler.jdbc.DefaultJdbcCustomization;
import com.github.kagkarlsson.scheduler.jdbc.Queries;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MssqlJdbcCustomization
extends DefaultJdbcCustomization {
    private static final Logger LOG = LoggerFactory.getLogger(MssqlJdbcCustomization.class);

    public MssqlJdbcCustomization() {
        super(true);
    }

    public MssqlJdbcCustomization(boolean persistTimestampInUTC) {
        super(persistTimestampInUTC);
        if (!persistTimestampInUTC) {
            LOG.warn("{} must explicitly specify timezone when persisting a timestamp. Persisting timestamp with undefined timezone is not recommended and will likely cause issues", (Object)this.getClass().getName());
        }
    }

    @Override
    public String getName() {
        return "MSSQL";
    }

    @Override
    public boolean supportsGenericLockAndFetch() {
        return true;
    }

    @Override
    public String createSelectDueQuery(String tableName, int limit, String andCondition, boolean orderByPriority) {
        return "SELECT  * FROM " + tableName + " WITH (READPAST) WHERE picked = ? AND execution_time <= ? " + andCondition + Queries.ansiSqlOrderPart(orderByPriority) + this.getQueryLimitPart(limit);
    }

    @Override
    public String createGenericSelectForUpdateQuery(String tableName, int limit, String requiredAndCondition, boolean orderByPriority) {
        return Queries.selectForUpdate(tableName, Queries.ansiSqlOrderPart(orderByPriority), Queries.ansiSqlLimitPart(limit), requiredAndCondition, null, " WITH (READPAST,ROWLOCK) ");
    }
}

