/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.task.helper;

import com.github.kagkarlsson.scheduler.Clock;
import com.github.kagkarlsson.scheduler.SchedulerClient;
import com.github.kagkarlsson.scheduler.task.AbstractTask;
import com.github.kagkarlsson.scheduler.task.DeadExecutionHandler;
import com.github.kagkarlsson.scheduler.task.FailureHandler;
import com.github.kagkarlsson.scheduler.task.NextExecutionTime;
import com.github.kagkarlsson.scheduler.task.OnStartup;
import com.github.kagkarlsson.scheduler.task.SchedulableInstance;
import com.github.kagkarlsson.scheduler.task.SchedulableTaskInstance;
import com.github.kagkarlsson.scheduler.task.TaskInstance;
import com.github.kagkarlsson.scheduler.task.helper.ScheduleOnStartup;
import java.time.Instant;
import java.util.function.Function;

public abstract class CustomTask<T>
extends AbstractTask<T>
implements OnStartup {
    private ScheduleOnStartup<T> scheduleOnStartup;
    private final NextExecutionTime defaultExecutionTime;

    public CustomTask(String name, Class<T> dataClass, ScheduleOnStartup<T> scheduleOnStartup, Function<Instant, Instant> defaultExecutionTime, FailureHandler<T> failureHandler, DeadExecutionHandler<T> deadExecutionHandler) {
        super(name, dataClass, failureHandler, deadExecutionHandler);
        this.scheduleOnStartup = scheduleOnStartup;
        this.defaultExecutionTime = NextExecutionTime.from(defaultExecutionTime);
    }

    @Override
    public SchedulableInstance<T> schedulableInstance(String id) {
        return new SchedulableTaskInstance(new TaskInstance(this.getName(), id), this.defaultExecutionTime);
    }

    @Override
    public SchedulableInstance<T> schedulableInstance(String id, T data) {
        return new SchedulableTaskInstance<T>(new TaskInstance<T>(this.getName(), id, data), this.defaultExecutionTime);
    }

    @Override
    public void onStartup(SchedulerClient scheduler, Clock clock) {
        if (this.scheduleOnStartup != null) {
            this.scheduleOnStartup.apply(scheduler, clock, this);
        }
    }

    @Override
    public String toString() {
        return "CustomTask name=" + this.getName();
    }
}

