/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.event;

import com.github.kagkarlsson.scheduler.CurrentlyExecuting;
import com.github.kagkarlsson.scheduler.event.AbstractSchedulerListener;
import com.github.kagkarlsson.scheduler.stats.StatsRegistry;
import com.github.kagkarlsson.scheduler.task.Execution;
import com.github.kagkarlsson.scheduler.task.ExecutionComplete;
import com.github.kagkarlsson.scheduler.task.TaskInstanceId;
import java.time.Instant;

public interface SchedulerListener {
    public static final SchedulerListener NOOP = new AbstractSchedulerListener(){};

    public void onExecutionScheduled(TaskInstanceId var1, Instant var2);

    public void onExecutionStart(CurrentlyExecuting var1);

    public void onExecutionComplete(ExecutionComplete var1);

    public void onExecutionDead(Execution var1);

    public void onExecutionFailedHeartbeat(CurrentlyExecuting var1);

    public void onSchedulerEvent(SchedulerEventType var1);

    public void onCandidateEvent(CandidateEventType var1);

    public static enum CandidateEventType {
        STALE(StatsRegistry.CandidateStatsEvent.STALE),
        ALREADY_PICKED(StatsRegistry.CandidateStatsEvent.ALREADY_PICKED),
        EXECUTED(StatsRegistry.CandidateStatsEvent.EXECUTED);

        private final StatsRegistry.CandidateStatsEvent statsRegistryEvent;

        private CandidateEventType(StatsRegistry.CandidateStatsEvent statsRegistryEvent) {
            this.statsRegistryEvent = statsRegistryEvent;
        }

        public StatsRegistry.CandidateStatsEvent toStatsRegistryEvent() {
            return this.statsRegistryEvent;
        }
    }

    public static enum SchedulerEventType {
        UNEXPECTED_ERROR(StatsRegistry.SchedulerStatsEvent.UNEXPECTED_ERROR),
        FAILED_HEARTBEAT(StatsRegistry.SchedulerStatsEvent.FAILED_HEARTBEAT),
        COMPLETIONHANDLER_ERROR(StatsRegistry.SchedulerStatsEvent.COMPLETIONHANDLER_ERROR),
        FAILUREHANDLER_ERROR(StatsRegistry.SchedulerStatsEvent.FAILUREHANDLER_ERROR),
        DEAD_EXECUTION(StatsRegistry.SchedulerStatsEvent.DEAD_EXECUTION),
        RAN_UPDATE_HEARTBEATS(StatsRegistry.SchedulerStatsEvent.RAN_UPDATE_HEARTBEATS),
        RAN_DETECT_DEAD(StatsRegistry.SchedulerStatsEvent.RAN_DETECT_DEAD),
        RAN_EXECUTE_DUE(StatsRegistry.SchedulerStatsEvent.RAN_EXECUTE_DUE),
        FAILED_MULTIPLE_HEARTBEATS(StatsRegistry.SchedulerStatsEvent.FAILED_MULTIPLE_HEARTBEATS),
        UNRESOLVED_TASK(StatsRegistry.SchedulerStatsEvent.UNRESOLVED_TASK);

        private final StatsRegistry.SchedulerStatsEvent statsRegistryEvent;

        private SchedulerEventType(StatsRegistry.SchedulerStatsEvent statsRegistryEvent) {
            this.statsRegistryEvent = statsRegistryEvent;
        }

        public StatsRegistry.SchedulerStatsEvent toStatsRegistryEvent() {
            return this.statsRegistryEvent;
        }
    }
}

