/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler;

import com.github.kagkarlsson.scheduler.Clock;
import com.github.kagkarlsson.scheduler.HeartbeatConfig;
import com.github.kagkarlsson.scheduler.HeartbeatState;
import com.github.kagkarlsson.scheduler.task.Execution;
import com.github.kagkarlsson.scheduler.task.TaskInstance;
import java.time.Duration;
import java.time.Instant;

public class CurrentlyExecuting {
    private final Execution execution;
    private final Clock clock;
    private final Instant startTime;
    private final HeartbeatState heartbeatState;

    public CurrentlyExecuting(Execution execution, Clock clock, HeartbeatConfig heartbeatConfig) {
        this.execution = execution;
        this.clock = clock;
        this.startTime = clock.now();
        this.heartbeatState = new HeartbeatState(clock, this.startTime, heartbeatConfig);
    }

    public Duration getDuration() {
        return Duration.between(this.startTime, this.clock.now());
    }

    public TaskInstance getTaskInstance() {
        return this.execution.taskInstance;
    }

    public Execution getExecution() {
        return this.execution;
    }

    public HeartbeatState getHeartbeatState() {
        return this.heartbeatState;
    }

    public void heartbeat(boolean successful, Instant now) {
        this.heartbeatState.heartbeat(successful, now);
    }
}

