/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.jdbc;

import com.github.kagkarlsson.scheduler.jdbc.DefaultJdbcCustomization;
import com.github.kagkarlsson.scheduler.jdbc.Queries;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Calendar;
import java.util.TimeZone;

public class MssqlJdbcCustomization
extends DefaultJdbcCustomization {
    @Override
    public String getName() {
        return "MSSQL";
    }

    @Override
    public void setInstant(PreparedStatement p, int index, Instant value) throws SQLException {
        p.setTimestamp(index, value != null ? Timestamp.from(value) : null, Calendar.getInstance(TimeZone.getTimeZone("UTC")));
    }

    @Override
    public boolean supportsGenericLockAndFetch() {
        return true;
    }

    @Override
    public String createSelectDueQuery(String tableName, int limit, String andCondition) {
        return "SELECT  * FROM " + tableName + " WITH (READPAST) WHERE picked = ? AND execution_time <= ? " + andCondition + " ORDER BY execution_time ASC " + this.getQueryLimitPart(limit);
    }

    @Override
    public String createGenericSelectForUpdateQuery(String tableName, int limit, String requiredAndCondition) {
        return Queries.selectForUpdate(tableName, Queries.ansiSqlLimitPart(limit), requiredAndCondition, null, " WITH (READPAST,ROWLOCK) ");
    }
}

