/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.serializer;

import com.github.kagkarlsson.scheduler.serializer.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializerWithFallbackDeserializers
implements Serializer {
    private static final Logger LOG = LoggerFactory.getLogger(SerializerWithFallbackDeserializers.class);
    private final Serializer serializer;
    private final Serializer fallbackDeserializer;

    public SerializerWithFallbackDeserializers(Serializer serializer, Serializer fallbackDeserializer) {
        this.serializer = serializer;
        this.fallbackDeserializer = fallbackDeserializer;
    }

    @Override
    public byte[] serialize(Object data) {
        return this.serializer.serialize(data);
    }

    @Override
    public <T> T deserialize(Class<T> clazz, byte[] serializedData) {
        try {
            return this.serializer.deserialize(clazz, serializedData);
        }
        catch (Exception e) {
            LOG.debug("Failed to deserialize data. Trying fallback Serializer.", (Throwable)e);
            return this.fallbackDeserializer.deserialize(clazz, serializedData);
        }
    }
}

