/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.task.schedule;

import com.github.kagkarlsson.scheduler.task.ExecutionComplete;
import com.github.kagkarlsson.scheduler.task.schedule.Schedule;
import com.github.kagkarlsson.shaded.cronutils.model.Cron;
import com.github.kagkarlsson.shaded.cronutils.model.CronType;
import com.github.kagkarlsson.shaded.cronutils.model.definition.CronDefinitionBuilder;
import com.github.kagkarlsson.shaded.cronutils.model.time.ExecutionTime;
import com.github.kagkarlsson.shaded.cronutils.parser.CronParser;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CronSchedule
implements Schedule,
Serializable {
    private static final String DISABLED = "-";
    private static final Logger LOG = LoggerFactory.getLogger(CronSchedule.class);
    private final String pattern;
    private final ZoneId zoneId;
    private transient ExecutionTime cronExecutionTime;

    private CronSchedule() {
        this.pattern = null;
        this.zoneId = ZoneId.systemDefault();
    }

    public CronSchedule(String pattern) {
        this(pattern, ZoneId.systemDefault());
    }

    public CronSchedule(String pattern, ZoneId zoneId) {
        this.pattern = pattern;
        if (zoneId == null) {
            throw new IllegalArgumentException("zoneId may not be null");
        }
        this.zoneId = zoneId;
        this.lazyInitExecutionTime();
    }

    @Override
    public Instant getNextExecutionTime(ExecutionComplete executionComplete) {
        this.lazyInitExecutionTime();
        ZonedDateTime lastDone = ZonedDateTime.ofInstant(executionComplete.getTimeDone(), this.zoneId);
        Optional<ZonedDateTime> nextTime = this.cronExecutionTime.nextExecution(lastDone);
        if (!nextTime.isPresent()) {
            LOG.error("Cron-pattern did not return any further execution-times. This behavior is currently not supported by the scheduler. Setting next execution-time to far-future.");
            return Instant.now().plus(1000L, ChronoUnit.YEARS);
        }
        return nextTime.get().toInstant();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInitExecutionTime() {
        if (this.cronExecutionTime != null) {
            return;
        }
        CronSchedule cronSchedule = this;
        synchronized (cronSchedule) {
            if (this.cronExecutionTime == null) {
                if (this.isDisabled()) {
                    this.cronExecutionTime = new DisabledScheduleExecutionTime();
                } else {
                    CronParser parser = new CronParser(CronDefinitionBuilder.instanceDefinitionFor(CronType.SPRING));
                    Cron cron = parser.parse(this.pattern);
                    this.cronExecutionTime = ExecutionTime.forCron(cron);
                }
            }
        }
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    public String toString() {
        return "CronSchedule pattern=" + this.pattern + ", zone=" + this.zoneId;
    }

    public String getPattern() {
        return this.pattern;
    }

    public ZoneId getZoneId() {
        return this.zoneId;
    }

    @Override
    public boolean isDisabled() {
        return DISABLED.equals(this.pattern);
    }

    private static class DisabledScheduleExecutionTime
    implements ExecutionTime {
        private DisabledScheduleExecutionTime() {
        }

        @Override
        public Optional<ZonedDateTime> nextExecution(ZonedDateTime date) {
            throw this.unsupportedException();
        }

        @Override
        public Optional<Duration> timeToNextExecution(ZonedDateTime date) {
            throw this.unsupportedException();
        }

        @Override
        public Optional<ZonedDateTime> lastExecution(ZonedDateTime date) {
            throw this.unsupportedException();
        }

        @Override
        public Optional<Duration> timeFromLastExecution(ZonedDateTime date) {
            throw this.unsupportedException();
        }

        @Override
        public boolean isMatch(ZonedDateTime date) {
            throw this.unsupportedException();
        }

        private UnsupportedOperationException unsupportedException() {
            return new UnsupportedOperationException("Schedule is marked as disabled. Method should never be called");
        }
    }
}

