/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.task.schedule;

import com.github.kagkarlsson.scheduler.task.ExecutionComplete;
import com.github.kagkarlsson.scheduler.task.schedule.Schedule;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class Daily
implements Schedule,
Serializable {
    private final List<LocalTime> times;
    private final ZoneId zone;

    public Daily(LocalTime ... times) {
        this(ZoneId.systemDefault(), Arrays.asList(times));
    }

    public Daily(List<LocalTime> times) {
        this(ZoneId.systemDefault(), times);
    }

    public Daily(ZoneId zone, LocalTime ... times) {
        this(zone, Arrays.asList(times));
    }

    public Daily(ZoneId zone, List<LocalTime> times) {
        this.zone = Objects.requireNonNull(zone, "zone cannot be null");
        if (times.size() < 1) {
            throw new IllegalArgumentException("times cannot be empty");
        }
        this.times = times.stream().sorted().collect(Collectors.toList());
    }

    @Override
    public Instant getNextExecutionTime(ExecutionComplete executionComplete) {
        Instant timeDone = executionComplete.getTimeDone();
        LocalDate doneDate = timeDone.atZone(this.zone).toLocalDate();
        for (LocalTime time : this.times) {
            Instant nextTimeCandidate = ZonedDateTime.of(doneDate, time, this.zone).toInstant();
            if (!nextTimeCandidate.isAfter(timeDone)) continue;
            return nextTimeCandidate;
        }
        return ZonedDateTime.of(doneDate, this.times.get(0), this.zone).plusDays(1L).toInstant();
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Daily)) {
            return false;
        }
        Daily that = (Daily)o;
        return Objects.equals(this.times, that.times) && Objects.equals(this.zone, that.zone);
    }

    public final int hashCode() {
        return Objects.hash(this.times, this.zone);
    }

    public String toString() {
        return "Daily times=" + this.times + ", zone=" + this.zone;
    }
}

