/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.task.helper;

import com.github.kagkarlsson.scheduler.Clock;
import com.github.kagkarlsson.scheduler.SchedulerClient;
import com.github.kagkarlsson.scheduler.task.AbstractTask;
import com.github.kagkarlsson.scheduler.task.CompletionHandler;
import com.github.kagkarlsson.scheduler.task.DeadExecutionHandler;
import com.github.kagkarlsson.scheduler.task.ExecutionContext;
import com.github.kagkarlsson.scheduler.task.FailureHandler;
import com.github.kagkarlsson.scheduler.task.OnStartup;
import com.github.kagkarlsson.scheduler.task.SchedulableInstance;
import com.github.kagkarlsson.scheduler.task.SchedulableTaskInstance;
import com.github.kagkarlsson.scheduler.task.TaskInstance;
import com.github.kagkarlsson.scheduler.task.TaskInstanceId;
import com.github.kagkarlsson.scheduler.task.helper.ScheduleOnStartup;
import com.github.kagkarlsson.scheduler.task.helper.ScheduleRecurringOnStartup;
import com.github.kagkarlsson.scheduler.task.schedule.Schedule;

public abstract class RecurringTask<T>
extends AbstractTask<T>
implements OnStartup {
    public static final String INSTANCE = "recurring";
    private final CompletionHandler.OnCompleteReschedule<T> onComplete;
    private final Schedule schedule;
    private ScheduleOnStartup<T> scheduleOnStartup;

    public RecurringTask(String name, Schedule schedule, Class<T> dataClass) {
        this(name, schedule, dataClass, new ScheduleRecurringOnStartup<Object>(INSTANCE, null, schedule), new FailureHandler.OnFailureReschedule(schedule), new DeadExecutionHandler.ReviveDeadExecution());
    }

    public RecurringTask(String name, Schedule schedule, Class<T> dataClass, T initialData) {
        this(name, schedule, dataClass, new ScheduleRecurringOnStartup<T>(INSTANCE, initialData, schedule), new FailureHandler.OnFailureReschedule(schedule), new DeadExecutionHandler.ReviveDeadExecution());
    }

    public RecurringTask(String name, Schedule schedule, Class<T> dataClass, ScheduleRecurringOnStartup<T> scheduleOnStartup, FailureHandler<T> failureHandler, DeadExecutionHandler<T> deadExecutionHandler) {
        super(name, dataClass, failureHandler, deadExecutionHandler);
        this.onComplete = new CompletionHandler.OnCompleteReschedule(schedule);
        this.schedule = schedule;
        this.scheduleOnStartup = scheduleOnStartup;
    }

    @Override
    public SchedulableInstance<T> schedulableInstance(String id) {
        return new SchedulableTaskInstance(new TaskInstance(this.getName(), id), this.schedule::getInitialExecutionTime);
    }

    @Override
    public SchedulableInstance<T> schedulableInstance(String id, T data) {
        return new SchedulableTaskInstance<T>(new TaskInstance<T>(this.getName(), id, data), this.schedule::getInitialExecutionTime);
    }

    @Override
    public void onStartup(SchedulerClient scheduler, Clock clock) {
        if (this.scheduleOnStartup != null) {
            this.scheduleOnStartup.apply(scheduler, clock, this);
        }
    }

    @Override
    public CompletionHandler<T> execute(TaskInstance<T> taskInstance, ExecutionContext executionContext) {
        this.executeRecurringly(taskInstance, executionContext);
        return this.onComplete;
    }

    public abstract void executeRecurringly(TaskInstance<T> var1, ExecutionContext var2);

    public TaskInstanceId getDefaultTaskInstance() {
        return TaskInstanceId.of(this.name, INSTANCE);
    }

    @Override
    public String toString() {
        return "RecurringTask name=" + this.getName() + ", onComplete=" + this.onComplete;
    }
}

