/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler;

import com.github.kagkarlsson.scheduler.ClientEvent;
import com.github.kagkarlsson.scheduler.Clock;
import com.github.kagkarlsson.scheduler.SchedulerClientEventListener;
import com.github.kagkarlsson.scheduler.SchedulerState;
import com.github.kagkarlsson.scheduler.Waiter;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TriggerCheckForDueExecutions
implements SchedulerClientEventListener {
    private static final Logger LOG = LoggerFactory.getLogger(TriggerCheckForDueExecutions.class);
    private SchedulerState schedulerState;
    private Clock clock;
    private Waiter executeDueWaiter;

    public TriggerCheckForDueExecutions(SchedulerState schedulerState, Clock clock, Waiter executeDueWaiter) {
        this.schedulerState = schedulerState;
        this.clock = clock;
        this.executeDueWaiter = executeDueWaiter;
    }

    @Override
    public void newEvent(ClientEvent event) {
        Instant scheduledToExecutionTime;
        ClientEvent.ClientEventContext ctx = event.getContext();
        ClientEvent.EventType eventType = ctx.getEventType();
        if (!this.schedulerState.isStarted() || this.schedulerState.isShuttingDown()) {
            LOG.debug("Will not act on scheduling event for execution (task: '{}', id: '{}') as scheduler is starting or shutting down.", (Object)ctx.getTaskInstanceId().getTaskName(), (Object)ctx.getTaskInstanceId().getId());
            return;
        }
        if ((eventType == ClientEvent.EventType.SCHEDULE || eventType == ClientEvent.EventType.RESCHEDULE) && (scheduledToExecutionTime = ctx.getExecutionTime()).toEpochMilli() <= this.clock.now().toEpochMilli()) {
            LOG.info("Task-instance scheduled to run directly, triggering check for due exections (unless it is already running). Task: {}, instance: {}", (Object)ctx.getTaskInstanceId().getTaskName(), (Object)ctx.getTaskInstanceId().getId());
            this.executeDueWaiter.wakeOrSkipNextWait();
        }
    }
}

