/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler;

import com.github.kagkarlsson.scheduler.Clock;
import com.github.kagkarlsson.scheduler.CurrentlyExecuting;
import com.github.kagkarlsson.scheduler.Executor;
import com.github.kagkarlsson.scheduler.SchedulerClient;
import com.github.kagkarlsson.scheduler.SchedulerState;
import com.github.kagkarlsson.scheduler.TaskRepository;
import com.github.kagkarlsson.scheduler.TaskResolver;
import com.github.kagkarlsson.scheduler.logging.ConfigurableLogger;
import com.github.kagkarlsson.scheduler.stats.StatsRegistry;
import com.github.kagkarlsson.scheduler.task.CompletionHandler;
import com.github.kagkarlsson.scheduler.task.Execution;
import com.github.kagkarlsson.scheduler.task.ExecutionComplete;
import com.github.kagkarlsson.scheduler.task.ExecutionContext;
import com.github.kagkarlsson.scheduler.task.ExecutionOperations;
import com.github.kagkarlsson.scheduler.task.Task;
import java.time.Instant;
import java.util.Optional;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExecutePicked
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutePicked.class);
    private final Executor executor;
    private final TaskRepository taskRepository;
    private final SchedulerClient schedulerClient;
    private final StatsRegistry statsRegistry;
    private final TaskResolver taskResolver;
    private final SchedulerState schedulerState;
    private final ConfigurableLogger failureLogger;
    private final Clock clock;
    private final Execution pickedExecution;

    public ExecutePicked(Executor executor, TaskRepository taskRepository, SchedulerClient schedulerClient, StatsRegistry statsRegistry, TaskResolver taskResolver, SchedulerState schedulerState, ConfigurableLogger failureLogger, Clock clock, Execution pickedExecution) {
        this.executor = executor;
        this.taskRepository = taskRepository;
        this.schedulerClient = schedulerClient;
        this.statsRegistry = statsRegistry;
        this.taskResolver = taskResolver;
        this.schedulerState = schedulerState;
        this.failureLogger = failureLogger;
        this.clock = clock;
        this.pickedExecution = pickedExecution;
    }

    @Override
    public void run() {
        UUID executionId = this.executor.addCurrentlyProcessing(new CurrentlyExecuting(this.pickedExecution, this.clock));
        try {
            this.statsRegistry.register(StatsRegistry.CandidateStatsEvent.EXECUTED);
            this.executePickedExecution(this.pickedExecution);
        }
        finally {
            this.executor.removeCurrentlyProcessing(executionId);
        }
    }

    private void executePickedExecution(Execution execution) {
        Optional<Task> task = this.taskResolver.resolve(execution.taskInstance.getTaskName());
        if (!task.isPresent()) {
            LOG.error("Failed to find implementation for task with name '{}'. Should have been excluded in JdbcRepository.", (Object)execution.taskInstance.getTaskName());
            this.statsRegistry.register(StatsRegistry.SchedulerStatsEvent.UNEXPECTED_ERROR);
            return;
        }
        Instant executionStarted = this.clock.now();
        try {
            LOG.debug("Executing " + execution);
            CompletionHandler completion = task.get().execute(execution.taskInstance, new ExecutionContext(this.schedulerState, execution, this.schedulerClient));
            LOG.debug("Execution done");
            this.complete(completion, execution, executionStarted);
            this.statsRegistry.register(StatsRegistry.ExecutionStatsEvent.COMPLETED);
        }
        catch (RuntimeException unhandledException) {
            this.failure(task.get(), execution, unhandledException, executionStarted, "Unhandled exception");
            this.statsRegistry.register(StatsRegistry.ExecutionStatsEvent.FAILED);
        }
        catch (Throwable unhandledError) {
            this.failure(task.get(), execution, unhandledError, executionStarted, "Error");
            this.statsRegistry.register(StatsRegistry.ExecutionStatsEvent.FAILED);
        }
    }

    private void complete(CompletionHandler completion, Execution execution, Instant executionStarted) {
        ExecutionComplete completeEvent = ExecutionComplete.success(execution, executionStarted, this.clock.now());
        try {
            completion.complete(completeEvent, new ExecutionOperations(this.taskRepository, execution));
            this.statsRegistry.registerSingleCompletedExecution(completeEvent);
        }
        catch (Throwable e) {
            this.statsRegistry.register(StatsRegistry.SchedulerStatsEvent.COMPLETIONHANDLER_ERROR);
            this.statsRegistry.register(StatsRegistry.SchedulerStatsEvent.UNEXPECTED_ERROR);
            LOG.error("Failed while completing execution {}. Execution will likely remain scheduled and locked/picked. The execution should be detected as dead after a while, and handled according to the tasks DeadExecutionHandler.", (Object)execution, (Object)e);
        }
    }

    private void failure(Task task, Execution execution, Throwable cause, Instant executionStarted, String errorMessagePrefix) {
        String logMessage = errorMessagePrefix + " during execution of task with name '{}'. Treating as failure.";
        this.failureLogger.log(logMessage, cause, task.getName());
        ExecutionComplete completeEvent = ExecutionComplete.failure(execution, executionStarted, this.clock.now(), cause);
        try {
            task.getFailureHandler().onFailure(completeEvent, new ExecutionOperations(this.taskRepository, execution));
            this.statsRegistry.registerSingleCompletedExecution(completeEvent);
        }
        catch (Throwable e) {
            this.statsRegistry.register(StatsRegistry.SchedulerStatsEvent.FAILUREHANDLER_ERROR);
            this.statsRegistry.register(StatsRegistry.SchedulerStatsEvent.UNEXPECTED_ERROR);
            LOG.error("Failed while completing execution {}. Execution will likely remain scheduled and locked/picked. The execution should be detected as dead after a while, and handled according to the tasks DeadExecutionHandler.", (Object)execution, (Object)e);
        }
    }
}

